(ns de.phenomdevel.formalicious.form.select
  (:require
   [plumbing.core :refer [letk]]
   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.util :as u]
   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Helper

(defn field-spec->options
  [field-spec]
  (letk [[{options nil}
          {options-path nil}
          {option-transform nil}]
         field-spec

         options
         (or options
             @(subscribe [:state/get-at (u/collify options-path)]))]

    (if-not option-transform
      options
      (mapv option-transform options))))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{id ""}
          {class nil}
          {order-by :id}
          {on-change nil}
          {data-path nil}
          {multiple false}
          {value-transform identity}
          {option-label-key :label}
          {option-value-key :id}]
         field-spec

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (h/with-on-change on-change value-transform data-path))]

    (fn [field-spec value]
      (letk [[{disabled false}]
             field-spec

             attrs
             (-> base-attrs
                 (h/with-value value)
                 (h/with-disabled disabled))

             options
             (->> field-spec
                  (field-spec->options)
                  (map h/ensure-id)
                  (sort-by order-by))

             option-fields
             (for [option options]
               (letk [[{id ""}]
                      option]

                 (-> {:value (get option option-value-key (get option :id))}
                     (h/with-option-wrapper id)
                     (conj (str (get option option-label-key "NO VALUE"))))))

             select-field
             (-> attrs
                 (h/with-select-field-wrapper)
                 (h/with-contents (h/default-option field-spec) option-fields)
                 (h/with-label field-spec))]

        (-> {:class class}
            (h/with-input-field-wrapper)
            (h/with-contents select-field))))))
