(ns de.phenomdevel.formalicious.form.shared
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.dynamic :as dyn]))


;; =============================================================================
;; Helper

(def ^:private default-attribute-keys
  "These are the attribute keys which will be used without any transformation.
  If they're provided they will be rendered within the input-field."
  [:id :type :multiple :checked :placeholder :min :max :step :size])


;; =============================================================================
;; Public API

(defn field-spec->attrs
  [field-spec]
  (letk [[{disabled nil}
          {on-click nil}
          {on-change nil}
          {data-path nil}]
         field-spec]

    (-> field-spec
        (select-keys default-attribute-keys)
        (h/with-disabled disabled))))

(defn print-render-fn-infos
  [field-spec value]
  (letk [[{id nil}
          {type nil}
          {data-path []}]
         field-spec]

    (when @dyn/*print-debug?*
      (js/console.groupCollapsed
       (str "render-fn" " [form/" (name type) "] " "[" id "] " data-path))
      (js/console.log (str "value: " (pr-str value)))
      (doseq [[k v] field-spec]
        (js/console.log (str (name k) ": " (pr-str v))))
      (js/console.groupEnd))))
