(ns de.phenomdevel.formalicious.handler
  "Provides basic re-frame handlers which are used by formalicious."
  (:require
   [re-frame.core :refer [reg-event-db]]
   [taoensso.timbre :as log]

   [de.phenomdevel.formalicious.util :as u]
   [de.phenomdevel.formalicious.dynamic :as dyn]))


;; =============================================================================
;; Common Handler

(reg-event-db :state/update-at
  (fn [db [event path value]]
    (when @dyn/*print-debug?*
      (log/debug event (u/collify path) value))
    (assoc-in db (u/collify path) value)))
