// Compiled by ClojureScript 1.10.773 {}
goog.provide('de.phenomdevel.formalicious.helper');
goog.require('cljs.core');
goog.require('plumbing.core');
goog.require('re_frame.core');
goog.require('de.phenomdevel.formalicious.util');
goog.require('de.phenomdevel.formalicious.util.dom.element');
de.phenomdevel.formalicious.helper.on_click_handler = (function de$phenomdevel$formalicious$helper$on_click_handler(handler){
return (function (){
return re_frame.core.dispatch.call(null,de.phenomdevel.formalicious.util.collify.call(null,handler));
});
});
/**
 * Returns a default on-change-handler which will call `dispatch-sync`
 *   with event `:state/update-at`
 * 
 *   NOTE: We use `dispatch-sync` here because otherwise you can lose inputs if you
 *   type fast enough.
 */
de.phenomdevel.formalicious.helper.on_change_handler = (function de$phenomdevel$formalicious$helper$on_change_handler(data_path,value){
return re_frame.core.dispatch_sync.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("state","update-at","state/update-at",452764282),data_path,value], null));
});
/**
 * Returns a on-change-handler which will call `on-change-handler` with the
 *   given elements value for `:value` attribute.
 */
de.phenomdevel.formalicious.helper.value_on_change_handler = (function de$phenomdevel$formalicious$helper$value_on_change_handler(value_transform,data_path){
return (function (e){
var value = value_transform.call(null,de.phenomdevel.formalicious.util.dom.element.value.call(null,e));
return de.phenomdevel.formalicious.helper.on_change_handler.call(null,data_path,value);
});
});
/**
 * Returns a on-change-handler which will call `on-change-handler` with the
 *   given elements value for `:checked` attribute.
 */
de.phenomdevel.formalicious.helper.checked_on_change_handler = (function de$phenomdevel$formalicious$helper$checked_on_change_handler(data_path){
return (function (e){
var checked_QMARK_ = de.phenomdevel.formalicious.util.dom.element.checked_QMARK_.call(null,e);
return de.phenomdevel.formalicious.helper.on_change_handler.call(null,data_path,checked_QMARK_);
});
});
/**
 * Assocs key `:value` with the given value into the given `attrs` map.
 */
de.phenomdevel.formalicious.helper.with_value = (function de$phenomdevel$formalicious$helper$with_value(attrs,value){
return cljs.core.assoc.call(null,attrs,new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "";
}
})());
});
/**
 * Assocs key `:on-change` with the given on-change-handler
 *   or default on-change-handler if none is provided on `attrs`.
 */
de.phenomdevel.formalicious.helper.with_on_change = (function de$phenomdevel$formalicious$helper$with_on_change(attrs,on_change,value_transform,update_path){
var G__6907 = attrs;
var G__6907__$1 = ((cljs.core.fn_QMARK_.call(null,on_change))?cljs.core.assoc.call(null,G__6907,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change):G__6907);
if((on_change == null)){
return cljs.core.assoc.call(null,G__6907__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149),de.phenomdevel.formalicious.helper.value_on_change_handler.call(null,value_transform,update_path));
} else {
return G__6907__$1;
}
});
/**
 * Assocs key `:disabled` with the given value on `attrs`.
 */
de.phenomdevel.formalicious.helper.with_disabled = (function de$phenomdevel$formalicious$helper$with_disabled(attrs,disabled){
return cljs.core.assoc.call(null,attrs,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled);
});
/**
 * Assocs key `:on-click` with the given on-click-handler.
 */
de.phenomdevel.formalicious.helper.with_on_click = (function de$phenomdevel$formalicious$helper$with_on_click(attrs,on_click){
var on_click_STAR_ = ((cljs.core.fn_QMARK_.call(null,on_click))?on_click:(((on_click instanceof cljs.core.Keyword))?de.phenomdevel.formalicious.helper.on_click_handler.call(null,on_click):null));
return cljs.core.assoc.call(null,attrs,new cljs.core.Keyword(null,"on-click","on-click",1632826543),on_click_STAR_);
});
de.phenomdevel.formalicious.helper.with_class = (function de$phenomdevel$formalicious$helper$with_class(attrs,spec){
var G__6908 = attrs;
if(cljs.core.truth_(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(spec))){
return cljs.core.assoc.call(null,G__6908,new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(spec));
} else {
return G__6908;
}
});
/**
 * Wraps given `attrs` map within a [:div.input-field] element.
 */
de.phenomdevel.formalicious.helper.with_input_field_wrapper = (function de$phenomdevel$formalicious$helper$with_input_field_wrapper(attrs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pd__field","div.pd__field",1293563441),attrs], null);
});
de.phenomdevel.formalicious.helper.with_datalist_input = (function de$phenomdevel$formalicious$helper$with_datalist_input(attrs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),attrs], null);
});
/**
 * Wraps given `attrs` map within a [:option] element with
 *   `:key` assoced in `attrs` with value of given id.
 */
de.phenomdevel.formalicious.helper.with_option_wrapper = (function de$phenomdevel$formalicious$helper$with_option_wrapper(attrs,id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option.pd__select__option","option.pd__select__option",-847353947),cljs.core.assoc.call(null,attrs,new cljs.core.Keyword(null,"key","key",-1516042587),id)], null);
});
/**
 * Wraps given `attrs` map within a [:select.browser-default] element.
 */
de.phenomdevel.formalicious.helper.with_select_field_wrapper = (function de$phenomdevel$formalicious$helper$with_select_field_wrapper(attrs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.pd__select","select.pd__select",508158460),attrs], null);
});
/**
 * Wraps given `attrs` map within a [:datalist] element.
 */
de.phenomdevel.formalicious.helper.with_datalist_wrapper = (function de$phenomdevel$formalicious$helper$with_datalist_wrapper(attrs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"datalist.pd__datalist","datalist.pd__datalist",1683562243),attrs], null);
});
/**
 * Returns a basic option hiccup element generated of given `field-spec`
 */
de.phenomdevel.formalicious.helper.default_option = (function de$phenomdevel$formalicious$helper$default_option(field_spec){
var map6909 = field_spec;
var label = cljs.core.get.call(null,map6909,new cljs.core.Keyword(null,"label","label",1718410804),"");
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option.pd__select__option","option.pd__select__option",-847353947),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true,new cljs.core.Keyword(null,"value","value",305978217),null], null),label], null);
});
/**
 * Conj's label element into the given `field-wrapper`.
 */
de.phenomdevel.formalicious.helper.with_label = (function de$phenomdevel$formalicious$helper$with_label(field_wrapper,field_spec){
var map6910 = field_spec;
var id = cljs.core.get.call(null,map6910,new cljs.core.Keyword(null,"id","id",-1388402092),"");
var label = cljs.core.get.call(null,map6910,new cljs.core.Keyword(null,"label","label",1718410804),null);
var label__$1 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label.pd__label","label.pd__label",-1733512552),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"for","for",-1323786319),id], null),label], null);
if(cljs.core.truth_(label__$1)){
return cljs.core.conj.call(null,field_wrapper,label__$1);
} else {
return field_wrapper;
}
});
/**
 * Puts given contents into the given field-wrapper.
 */
de.phenomdevel.formalicious.helper.with_contents = (function de$phenomdevel$formalicious$helper$with_contents(var_args){
var args__4742__auto__ = [];
var len__4736__auto___6913 = arguments.length;
var i__4737__auto___6914 = (0);
while(true){
if((i__4737__auto___6914 < len__4736__auto___6913)){
args__4742__auto__.push((arguments[i__4737__auto___6914]));

var G__6915 = (i__4737__auto___6914 + (1));
i__4737__auto___6914 = G__6915;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return de.phenomdevel.formalicious.helper.with_contents.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(de.phenomdevel.formalicious.helper.with_contents.cljs$core$IFn$_invoke$arity$variadic = (function (field_wrapper,contents){
return cljs.core.into.call(null,field_wrapper,contents);
}));

(de.phenomdevel.formalicious.helper.with_contents.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(de.phenomdevel.formalicious.helper.with_contents.cljs$lang$applyTo = (function (seq6911){
var G__6912 = cljs.core.first.call(null,seq6911);
var seq6911__$1 = cljs.core.next.call(null,seq6911);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6912,seq6911__$1);
}));

de.phenomdevel.formalicious.helper.with_hint = (function de$phenomdevel$formalicious$helper$with_hint(field_wrapper,hint){
return cljs.core.conj.call(null,field_wrapper,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.pd__field.pd__hint","span.pd__field.pd__hint",1119908223),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),hint], null),"!"], null));
});
de.phenomdevel.formalicious.helper.ensure_id = (function de$phenomdevel$formalicious$helper$ensure_id(option){
if((!(cljs.core.map_QMARK_.call(null,option)))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),option,new cljs.core.Keyword(null,"label","label",1718410804),option], null);
} else {
var map6916 = option;
var id = cljs.core.get.call(null,map6916,new cljs.core.Keyword(null,"id","id",-1388402092),null);
var label = cljs.core.get.call(null,map6916,new cljs.core.Keyword(null,"label","label",1718410804),null);
if((id == null)){
return cljs.core.merge.call(null,option,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),label,new cljs.core.Keyword(null,"label","label",1718410804),label], null));
} else {
return option;
}
}
});
de.phenomdevel.formalicious.helper.wrap_validation_message = (function de$phenomdevel$formalicious$helper$wrap_validation_message(message){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.pd__validation-message","span.pd__validation-message",619092111),message], null);
});
de.phenomdevel.formalicious.helper.wrap_validation_messages = (function de$phenomdevel$formalicious$helper$wrap_validation_messages(messages){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.pd__validation-messages","span.pd__validation-messages",-332714654)], null),cljs.core.mapv.call(null,de.phenomdevel.formalicious.helper.wrap_validation_message,messages));
});
de.phenomdevel.formalicious.helper.with_validation = (function de$phenomdevel$formalicious$helper$with_validation(field_wrapper,messages){
return cljs.core.conj.call(null,field_wrapper,de.phenomdevel.formalicious.helper.wrap_validation_messages.call(null,messages));
});
de.phenomdevel.formalicious.helper.validate = (function de$phenomdevel$formalicious$helper$validate(validations,value){
var map6917 = validations;
var checks = cljs.core.get.call(null,map6917,new cljs.core.Keyword(null,"checks","checks",526134637),cljs.core.PersistentVector.EMPTY);
var multiple_QMARK_ = cljs.core.get.call(null,map6917,new cljs.core.Keyword(null,"multiple?","multiple?",-490002283),false);
return cljs.core.reduce.call(null,(function (messages,validation){
var vec__6918 = validation;
var pred = cljs.core.nth.call(null,vec__6918,(0),null);
var msg = cljs.core.nth.call(null,vec__6918,(1),null);
if(cljs.core.not.call(null,pred.call(null,value))){
return messages;
} else {
if(cljs.core.truth_(multiple_QMARK_)){
return cljs.core.conj.call(null,messages,msg);
} else {
return cljs.core.reduced.call(null,cljs.core.conj.call(null,messages,msg));
}
}
}),cljs.core.PersistentVector.EMPTY,checks);
});

//# sourceMappingURL=helper.js.map?rel=1598625892063
