(ns de.phenomdevel.formalicious.subscription
  "Provides basic re-frame subscriptions which are used by formalicious."
  (:require
   [re-frame.core :refer [reg-sub]]

   [de.phenomdevel.formalicious.util.log :as log]
   [de.phenomdevel.formalicious.dynamic :as dyn]
   [de.phenomdevel.formalicious.util :as fu]))


;; =============================================================================
;; Common Subscriptions

(reg-sub :state/get-at
  (fn [db [event path]]
    (when @dyn/*print-debug?*
      (log/debug (str "[called [subscription/:state/get-at]] for " (fu/collify path))))
    (get-in db (fu/collify path))))
