(ns de.phenomdevel.formalicious.validations
  (:require
   [clojure.string :as str]))


;; =============================================================================
;; Public API

(defn not-empty?
  "Retruns true if `v` is not nil and not empty"
  [v]
  (and (not (nil? v))
       (str/blank? v)))

(defn shorter-than
  [n]
  (fn [v]
    (< n (count v))))

(defn longer-than
  [n]
  (fn [v]
    (> n (count v))))

(defn is-number?
  [v]
  (when v
    (->> v
         (str)
         (re-matches #"\d+" )
         (boolean)
         (not))))
