(ns example.core
  (:require
   [goog.dom :as gdom]
   [reagent.core :as reagent]
   [re-frame.core :refer [dispatch] :as rf]

   [example.handler]
   [example.subscription]

   [example.views.app :as app]))


;; =============================================================================
;; Mount

(defn mount!
  []
  (reagent/render
    [app/view]
    (gdom/getElement "app")))


;; =============================================================================
;; Figwheel

(defn on-jsload
  []
  (js/console.clear)
  (rf/clear-subscription-cache!)
  (mount!))


;; =============================================================================
;; Init

(rf/reg-event-db :db/initialize
  (fn [db [_ seed]]
    seed))

(def seed
  {:form/data
   {}})

(defonce init!
  (do
    (dispatch [:db/initialize seed])
    (mount!)))
