(ns example.views.form-three
  (:require
   [de.phenomdevel.formalicious.core :as form]))



;; =============================================================================
;; Private

(def ^:private form-spec
  {:data-root
   [:form/data :table]

   :fields
   [{:id :table
     :type :table
     :column-specs
     [{:path [:salutation] :label "Salutation"}
      {:path [:first-name] :label "Firstname"}
      {:path [:last-name] :label "Lastname"}]
     :cell-default "-"}]})


;; =============================================================================
;; Public API

(defn render
  []
  (let [data
        {:table
         [{:first-name "Kevin"}
          {:first-name "Anna"}
          {:first-name "Karl"}]}]

    [form/render-form form-spec data]))
