// Compiled by ClojureScript 1.10.773 {}
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('plumbing.fnk.schema');
/**
 * A sentinel value representing missing portions of the input data.
 */
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
 * Updates the value in map m at k with the function f.
 * 
 *  Like update-in, but for updating a single top-level key.
 *  Any additional args will be passed to f after the value.
 * 
 *  WARNING As of Clojure 1.7 this function exists in clojure.core and
 *  will not be exported by this namespace.
 */
plumbing.core.update = (function plumbing$core$update(var_args){
var G__5022 = arguments.length;
switch (G__5022) {
case 3:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___5024 = arguments.length;
var i__4737__auto___5025 = (0);
while(true){
if((i__4737__auto___5025 < len__4736__auto___5024)){
args_arr__4757__auto__.push((arguments[i__4737__auto___5025]));

var G__5026 = (i__4737__auto___5025 + (1));
i__4737__auto___5025 = G__5026;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(plumbing.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
}));

(plumbing.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x1){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
}));

(plumbing.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x1,x2){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
}));

(plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x1,x2,xs){
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
}));

/** @this {Function} */
(plumbing.core.update.cljs$lang$applyTo = (function (seq5016){
var G__5017 = cljs.core.first.call(null,seq5016);
var seq5016__$1 = cljs.core.next.call(null,seq5016);
var G__5018 = cljs.core.first.call(null,seq5016__$1);
var seq5016__$2 = cljs.core.next.call(null,seq5016__$1);
var G__5019 = cljs.core.first.call(null,seq5016__$2);
var seq5016__$3 = cljs.core.next.call(null,seq5016__$2);
var G__5020 = cljs.core.first.call(null,seq5016__$3);
var seq5016__$4 = cljs.core.next.call(null,seq5016__$3);
var G__5021 = cljs.core.first.call(null,seq5016__$4);
var seq5016__$5 = cljs.core.next.call(null,seq5016__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5017,G__5018,G__5019,G__5020,G__5021,seq5016__$5);
}));

(plumbing.core.update.cljs$lang$maxFixedArity = (5));

/**
 * Build map k -> (f v) for [k v] in map, preserving the initial type
 */
plumbing.core.map_vals = (function plumbing$core$map_vals(f,m){
if(cljs.core.sorted_QMARK_.call(null,m)){
return cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__4721__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__5028_5044 = cljs.core.seq.call(null,m);
var chunk__5029_5045 = null;
var count__5030_5046 = (0);
var i__5031_5047 = (0);
while(true){
if((i__5031_5047 < count__5030_5046)){
var vec__5038_5048 = cljs.core._nth.call(null,chunk__5029_5045,i__5031_5047);
var k_5049 = cljs.core.nth.call(null,vec__5038_5048,(0),null);
var v_5050 = cljs.core.nth.call(null,vec__5038_5048,(1),null);
var m5027_5051 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5027_5051,k_5049,f.call(null,v_5050)));


var G__5052 = seq__5028_5044;
var G__5053 = chunk__5029_5045;
var G__5054 = count__5030_5046;
var G__5055 = (i__5031_5047 + (1));
seq__5028_5044 = G__5052;
chunk__5029_5045 = G__5053;
count__5030_5046 = G__5054;
i__5031_5047 = G__5055;
continue;
} else {
var temp__5735__auto___5056 = cljs.core.seq.call(null,seq__5028_5044);
if(temp__5735__auto___5056){
var seq__5028_5057__$1 = temp__5735__auto___5056;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5028_5057__$1)){
var c__4556__auto___5058 = cljs.core.chunk_first.call(null,seq__5028_5057__$1);
var G__5059 = cljs.core.chunk_rest.call(null,seq__5028_5057__$1);
var G__5060 = c__4556__auto___5058;
var G__5061 = cljs.core.count.call(null,c__4556__auto___5058);
var G__5062 = (0);
seq__5028_5044 = G__5059;
chunk__5029_5045 = G__5060;
count__5030_5046 = G__5061;
i__5031_5047 = G__5062;
continue;
} else {
var vec__5041_5063 = cljs.core.first.call(null,seq__5028_5057__$1);
var k_5064 = cljs.core.nth.call(null,vec__5041_5063,(0),null);
var v_5065 = cljs.core.nth.call(null,vec__5041_5063,(1),null);
var m5027_5066 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5027_5066,k_5064,f.call(null,v_5065)));


var G__5067 = cljs.core.next.call(null,seq__5028_5057__$1);
var G__5068 = null;
var G__5069 = (0);
var G__5070 = (0);
seq__5028_5044 = G__5067;
chunk__5029_5045 = G__5068;
count__5030_5046 = G__5069;
i__5031_5047 = G__5070;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__4721__auto__));

}
}
});
/**
 * Build map (f k) -> v for [k v] in map m
 */
plumbing.core.map_keys = (function plumbing$core$map_keys(f,m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__4721__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__5072_5088 = cljs.core.seq.call(null,m);
var chunk__5073_5089 = null;
var count__5074_5090 = (0);
var i__5075_5091 = (0);
while(true){
if((i__5075_5091 < count__5074_5090)){
var vec__5082_5092 = cljs.core._nth.call(null,chunk__5073_5089,i__5075_5091);
var k_5093 = cljs.core.nth.call(null,vec__5082_5092,(0),null);
var v_5094 = cljs.core.nth.call(null,vec__5082_5092,(1),null);
var m5071_5095 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5071_5095,f.call(null,k_5093),v_5094));


var G__5096 = seq__5072_5088;
var G__5097 = chunk__5073_5089;
var G__5098 = count__5074_5090;
var G__5099 = (i__5075_5091 + (1));
seq__5072_5088 = G__5096;
chunk__5073_5089 = G__5097;
count__5074_5090 = G__5098;
i__5075_5091 = G__5099;
continue;
} else {
var temp__5735__auto___5100 = cljs.core.seq.call(null,seq__5072_5088);
if(temp__5735__auto___5100){
var seq__5072_5101__$1 = temp__5735__auto___5100;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5072_5101__$1)){
var c__4556__auto___5102 = cljs.core.chunk_first.call(null,seq__5072_5101__$1);
var G__5103 = cljs.core.chunk_rest.call(null,seq__5072_5101__$1);
var G__5104 = c__4556__auto___5102;
var G__5105 = cljs.core.count.call(null,c__4556__auto___5102);
var G__5106 = (0);
seq__5072_5088 = G__5103;
chunk__5073_5089 = G__5104;
count__5074_5090 = G__5105;
i__5075_5091 = G__5106;
continue;
} else {
var vec__5085_5107 = cljs.core.first.call(null,seq__5072_5101__$1);
var k_5108 = cljs.core.nth.call(null,vec__5085_5107,(0),null);
var v_5109 = cljs.core.nth.call(null,vec__5085_5107,(1),null);
var m5071_5110 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5071_5110,f.call(null,k_5108),v_5109));


var G__5111 = cljs.core.next.call(null,seq__5072_5101__$1);
var G__5112 = null;
var G__5113 = (0);
var G__5114 = (0);
seq__5072_5088 = G__5111;
chunk__5073_5089 = G__5112;
count__5074_5090 = G__5113;
i__5075_5091 = G__5114;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__4721__auto__));
}
});
/**
 * Build map k -> (f k) for keys in ks
 */
plumbing.core.map_from_keys = (function plumbing$core$map_from_keys(f,ks){
var m_atom__4721__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__5116_5120 = cljs.core.seq.call(null,ks);
var chunk__5117_5121 = null;
var count__5118_5122 = (0);
var i__5119_5123 = (0);
while(true){
if((i__5119_5123 < count__5118_5122)){
var k_5124 = cljs.core._nth.call(null,chunk__5117_5121,i__5119_5123);
var m5115_5125 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5115_5125,k_5124,f.call(null,k_5124)));


var G__5126 = seq__5116_5120;
var G__5127 = chunk__5117_5121;
var G__5128 = count__5118_5122;
var G__5129 = (i__5119_5123 + (1));
seq__5116_5120 = G__5126;
chunk__5117_5121 = G__5127;
count__5118_5122 = G__5128;
i__5119_5123 = G__5129;
continue;
} else {
var temp__5735__auto___5130 = cljs.core.seq.call(null,seq__5116_5120);
if(temp__5735__auto___5130){
var seq__5116_5131__$1 = temp__5735__auto___5130;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5116_5131__$1)){
var c__4556__auto___5132 = cljs.core.chunk_first.call(null,seq__5116_5131__$1);
var G__5133 = cljs.core.chunk_rest.call(null,seq__5116_5131__$1);
var G__5134 = c__4556__auto___5132;
var G__5135 = cljs.core.count.call(null,c__4556__auto___5132);
var G__5136 = (0);
seq__5116_5120 = G__5133;
chunk__5117_5121 = G__5134;
count__5118_5122 = G__5135;
i__5119_5123 = G__5136;
continue;
} else {
var k_5137 = cljs.core.first.call(null,seq__5116_5131__$1);
var m5115_5138 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5115_5138,k_5137,f.call(null,k_5137)));


var G__5139 = cljs.core.next.call(null,seq__5116_5131__$1);
var G__5140 = null;
var G__5141 = (0);
var G__5142 = (0);
seq__5116_5120 = G__5139;
chunk__5117_5121 = G__5140;
count__5118_5122 = G__5141;
i__5119_5123 = G__5142;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__4721__auto__));
});
/**
 * Build map (f v) -> v for vals in vs
 */
plumbing.core.map_from_vals = (function plumbing$core$map_from_vals(f,vs){
var m_atom__4721__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__5144_5148 = cljs.core.seq.call(null,vs);
var chunk__5145_5149 = null;
var count__5146_5150 = (0);
var i__5147_5151 = (0);
while(true){
if((i__5147_5151 < count__5146_5150)){
var v_5152 = cljs.core._nth.call(null,chunk__5145_5149,i__5147_5151);
var m5143_5153 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5143_5153,f.call(null,v_5152),v_5152));


var G__5154 = seq__5144_5148;
var G__5155 = chunk__5145_5149;
var G__5156 = count__5146_5150;
var G__5157 = (i__5147_5151 + (1));
seq__5144_5148 = G__5154;
chunk__5145_5149 = G__5155;
count__5146_5150 = G__5156;
i__5147_5151 = G__5157;
continue;
} else {
var temp__5735__auto___5158 = cljs.core.seq.call(null,seq__5144_5148);
if(temp__5735__auto___5158){
var seq__5144_5159__$1 = temp__5735__auto___5158;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5144_5159__$1)){
var c__4556__auto___5160 = cljs.core.chunk_first.call(null,seq__5144_5159__$1);
var G__5161 = cljs.core.chunk_rest.call(null,seq__5144_5159__$1);
var G__5162 = c__4556__auto___5160;
var G__5163 = cljs.core.count.call(null,c__4556__auto___5160);
var G__5164 = (0);
seq__5144_5148 = G__5161;
chunk__5145_5149 = G__5162;
count__5146_5150 = G__5163;
i__5147_5151 = G__5164;
continue;
} else {
var v_5165 = cljs.core.first.call(null,seq__5144_5159__$1);
var m5143_5166 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5143_5166,f.call(null,v_5165),v_5165));


var G__5167 = cljs.core.next.call(null,seq__5144_5159__$1);
var G__5168 = null;
var G__5169 = (0);
var G__5170 = (0);
seq__5144_5148 = G__5167;
chunk__5145_5149 = G__5168;
count__5146_5150 = G__5169;
i__5147_5151 = G__5170;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__4721__auto__));
});
/**
 * Dissociate this keyseq from m, removing any empty maps created as a result
 * (including at the top-level).
 */
plumbing.core.dissoc_in = (function plumbing$core$dissoc_in(m,p__5171){
var vec__5172 = p__5171;
var seq__5173 = cljs.core.seq.call(null,vec__5172);
var first__5174 = cljs.core.first.call(null,seq__5173);
var seq__5173__$1 = cljs.core.next.call(null,seq__5173);
var k = first__5174;
var ks = seq__5173__$1;
if(cljs.core.truth_(m)){
var temp__5733__auto__ = (function (){var and__4115__auto__ = ks;
if(and__4115__auto__){
return plumbing.core.dissoc_in.call(null,cljs.core.get.call(null,m,k),ks);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var res = temp__5733__auto__;
return cljs.core.assoc.call(null,m,k,res);
} else {
var res = cljs.core.dissoc.call(null,m,k);
if(cljs.core.empty_QMARK_.call(null,res)){
return null;
} else {
return res;
}
}
} else {
return null;
}
});
/**
 * Recursively convert maps in m (including itself)
 * to have keyword keys instead of string
 */
plumbing.core.keywordize_map = (function plumbing$core$keywordize_map(x){
if(cljs.core.map_QMARK_.call(null,x)){
var m_atom__4721__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__5176_5192 = cljs.core.seq.call(null,x);
var chunk__5177_5193 = null;
var count__5178_5194 = (0);
var i__5179_5195 = (0);
while(true){
if((i__5179_5195 < count__5178_5194)){
var vec__5186_5196 = cljs.core._nth.call(null,chunk__5177_5193,i__5179_5195);
var k_5197 = cljs.core.nth.call(null,vec__5186_5196,(0),null);
var v_5198 = cljs.core.nth.call(null,vec__5186_5196,(1),null);
var m5175_5199 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5175_5199,((typeof k_5197 === 'string')?cljs.core.keyword.call(null,k_5197):k_5197),plumbing.core.keywordize_map.call(null,v_5198)));


var G__5200 = seq__5176_5192;
var G__5201 = chunk__5177_5193;
var G__5202 = count__5178_5194;
var G__5203 = (i__5179_5195 + (1));
seq__5176_5192 = G__5200;
chunk__5177_5193 = G__5201;
count__5178_5194 = G__5202;
i__5179_5195 = G__5203;
continue;
} else {
var temp__5735__auto___5204 = cljs.core.seq.call(null,seq__5176_5192);
if(temp__5735__auto___5204){
var seq__5176_5205__$1 = temp__5735__auto___5204;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5176_5205__$1)){
var c__4556__auto___5206 = cljs.core.chunk_first.call(null,seq__5176_5205__$1);
var G__5207 = cljs.core.chunk_rest.call(null,seq__5176_5205__$1);
var G__5208 = c__4556__auto___5206;
var G__5209 = cljs.core.count.call(null,c__4556__auto___5206);
var G__5210 = (0);
seq__5176_5192 = G__5207;
chunk__5177_5193 = G__5208;
count__5178_5194 = G__5209;
i__5179_5195 = G__5210;
continue;
} else {
var vec__5189_5211 = cljs.core.first.call(null,seq__5176_5205__$1);
var k_5212 = cljs.core.nth.call(null,vec__5189_5211,(0),null);
var v_5213 = cljs.core.nth.call(null,vec__5189_5211,(1),null);
var m5175_5214 = cljs.core.deref.call(null,m_atom__4721__auto__);
cljs.core.reset_BANG_.call(null,m_atom__4721__auto__,cljs.core.assoc_BANG_.call(null,m5175_5214,((typeof k_5212 === 'string')?cljs.core.keyword.call(null,k_5212):k_5212),plumbing.core.keywordize_map.call(null,v_5213)));


var G__5215 = cljs.core.next.call(null,seq__5176_5205__$1);
var G__5216 = null;
var G__5217 = (0);
var G__5218 = (0);
seq__5176_5192 = G__5215;
chunk__5177_5193 = G__5216;
count__5178_5194 = G__5217;
i__5179_5195 = G__5218;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__4721__auto__));
} else {
if(cljs.core.seq_QMARK_.call(null,x)){
return cljs.core.map.call(null,plumbing.core.keywordize_map,x);
} else {
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.mapv.call(null,plumbing.core.keywordize_map,x);
} else {
return x;

}
}
}
});
/**
 * Like get but throw an exception if not found
 */
plumbing.core.safe_get = (function plumbing$core$safe_get(m,k){
var temp__5733__auto__ = cljs.core.find.call(null,m,k);
if(cljs.core.truth_(temp__5733__auto__)){
var pair__4811__auto__ = temp__5733__auto__;
return cljs.core.val.call(null,pair__4811__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m))));

}
});
/**
 * Like get-in but throws exception if not found
 */
plumbing.core.safe_get_in = (function plumbing$core$safe_get_in(m,ks){
while(true){
if(cljs.core.seq.call(null,ks)){
var G__5219 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__5220 = cljs.core.next.call(null,ks);
m = G__5219;
ks = G__5220;
continue;
} else {
return m;
}
break;
}
});
/**
 * Like assoc but only assocs when value is truthy
 */
plumbing.core.assoc_when = (function plumbing$core$assoc_when(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5233 = arguments.length;
var i__4737__auto___5234 = (0);
while(true){
if((i__4737__auto___5234 < len__4736__auto___5233)){
args__4742__auto__.push((arguments[i__4737__auto___5234]));

var G__5235 = (i__4737__auto___5234 + (1));
i__4737__auto___5234 = G__5235;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

return cljs.core.into.call(null,(function (){var or__4126__auto__ = m;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__4529__auto__ = (function plumbing$core$iter__5223(s__5224){
return (new cljs.core.LazySeq(null,(function (){
var s__5224__$1 = s__5224;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__5224__$1);
if(temp__5735__auto__){
var s__5224__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__5224__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__5224__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__5226 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__5225 = (0);
while(true){
if((i__5225 < size__4528__auto__)){
var vec__5227 = cljs.core._nth.call(null,c__4527__auto__,i__5225);
var k = cljs.core.nth.call(null,vec__5227,(0),null);
var v = cljs.core.nth.call(null,vec__5227,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__5226,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__5236 = (i__5225 + (1));
i__5225 = G__5236;
continue;
} else {
var G__5237 = (i__5225 + (1));
i__5225 = G__5237;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__5226),plumbing$core$iter__5223.call(null,cljs.core.chunk_rest.call(null,s__5224__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__5226),null);
}
} else {
var vec__5230 = cljs.core.first.call(null,s__5224__$2);
var k = cljs.core.nth.call(null,vec__5230,(0),null);
var v = cljs.core.nth.call(null,vec__5230,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$core$iter__5223.call(null,cljs.core.rest.call(null,s__5224__$2)));
} else {
var G__5238 = cljs.core.rest.call(null,s__5224__$2);
s__5224__$1 = G__5238;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
}));

(plumbing.core.assoc_when.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(plumbing.core.assoc_when.cljs$lang$applyTo = (function (seq5221){
var G__5222 = cljs.core.first.call(null,seq5221);
var seq5221__$1 = cljs.core.next.call(null,seq5221);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5222,seq5221__$1);
}));

/**
 * Like update-in but returns m unchanged if key-seq is not present.
 */
plumbing.core.update_in_when = (function plumbing$core$update_in_when(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5243 = arguments.length;
var i__4737__auto___5244 = (0);
while(true){
if((i__4737__auto___5244 < len__4736__auto___5243)){
args__4742__auto__.push((arguments[i__4737__auto___5244]));

var G__5245 = (i__4737__auto___5244 + (1));
i__4737__auto___5244 = G__5245;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,key_seq,f,args){
var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);
if((!((plumbing.core._PLUS_none_PLUS_ === found)))){
return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else {
return m;
}
}));

(plumbing.core.update_in_when.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(plumbing.core.update_in_when.cljs$lang$applyTo = (function (seq5239){
var G__5240 = cljs.core.first.call(null,seq5239);
var seq5239__$1 = cljs.core.next.call(null,seq5239);
var G__5241 = cljs.core.first.call(null,seq5239__$1);
var seq5239__$2 = cljs.core.next.call(null,seq5239__$1);
var G__5242 = cljs.core.first.call(null,seq5239__$2);
var seq5239__$3 = cljs.core.next.call(null,seq5239__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5240,G__5241,G__5242,seq5239__$3);
}));

/**
 * Like group-by, but accepts a map-fn that is applied to values before
 * collected.
 */
plumbing.core.grouped_map = (function plumbing$core$grouped_map(key_fn,map_fn,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){
var k = key_fn.call(null,x);
return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Like (apply concat s) but lazier (and shorter) 
 */
plumbing.core.aconcat = (function plumbing$core$aconcat(s){
return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){
return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){
var temp__5735__auto__ = cljs.core.next.call(null,s);
if(temp__5735__auto__){
var n = temp__5735__auto__;
return plumbing.core.aconcat.call(null,n);
} else {
return null;
}
}),null,null)));
});
/**
 * Takes a seqable and returns a lazy sequence that
 * is maximally lazy and doesn't realize elements due to either
 * chunking or apply.
 * 
 * Useful when you don't want chunking, for instance,
 * (first awesome-website? (map slurp +a-bunch-of-urls+))
 * may slurp up to 31 unneed webpages, wherease
 * (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
 * is guaranteed to stop slurping after the first awesome website.
 * 
 *   Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
 */
plumbing.core.unchunk = (function plumbing$core$unchunk(s){
if(cljs.core.seq.call(null,s)){
return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){
return plumbing.core.unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else {
return null;
}
});
/**
 * Return sum of (f x) for each x in xs
 */
plumbing.core.sum = (function plumbing$core$sum(var_args){
var G__5247 = arguments.length;
switch (G__5247) {
case 2:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(plumbing.core.sum.cljs$core$IFn$_invoke$arity$2 = (function (f,xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
}));

(plumbing.core.sum.cljs$core$IFn$_invoke$arity$1 = (function (xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
}));

(plumbing.core.sum.cljs$lang$maxFixedArity = 2);

/**
 * returns (first xs) when xs has only 1 element
 */
plumbing.core.singleton = (function plumbing$core$singleton(xs){
var temp__5735__auto__ = cljs.core.seq.call(null,xs);
if(temp__5735__auto__){
var xs__$1 = temp__5735__auto__;
if(cljs.core.next.call(null,xs__$1)){
return null;
} else {
return cljs.core.first.call(null,xs__$1);
}
} else {
return null;
}
});
/**
 * Returns [idx x] for x in seqable s
 */
plumbing.core.indexed = (function plumbing$core$indexed(s){
return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
 * Returns indices idx of sequence s where (f (nth s idx))
 */
plumbing.core.positions = (function plumbing$core$positions(f,s){
return cljs.core.keep_indexed.call(null,(function (i,x){
if(cljs.core.truth_(f.call(null,x))){
return i;
} else {
return null;
}
}),s);
});
/**
 * Returns elements of xs which return unique
 * values according to f. If multiple elements of xs return the same
 * value under f, the first is returned
 */
plumbing.core.distinct_by = (function plumbing$core$distinct_by(f,xs){
var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var iter__4529__auto__ = (function plumbing$core$distinct_by_$_iter__5249(s__5250){
return (new cljs.core.LazySeq(null,(function (){
var s__5250__$1 = s__5250;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__5250__$1);
if(temp__5735__auto__){
var s__5250__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__5250__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__5250__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__5252 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__5251 = (0);
while(true){
if((i__5251 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__5251);
var id = f.call(null,x);
if((!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))){
cljs.core.chunk_append.call(null,b__5252,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
);

var G__5253 = (i__5251 + (1));
i__5251 = G__5253;
continue;
} else {
var G__5254 = (i__5251 + (1));
i__5251 = G__5254;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__5252),plumbing$core$distinct_by_$_iter__5249.call(null,cljs.core.chunk_rest.call(null,s__5250__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__5252),null);
}
} else {
var x = cljs.core.first.call(null,s__5250__$2);
var id = f.call(null,x);
if((!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))){
return cljs.core.cons.call(null,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
,plumbing$core$distinct_by_$_iter__5249.call(null,cljs.core.rest.call(null,s__5250__$2)));
} else {
var G__5255 = cljs.core.rest.call(null,s__5250__$2);
s__5250__$1 = G__5255;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,xs);
});
/**
 * Analogy: partition:partition-all :: interleave:interleave-all
 */
plumbing.core.interleave_all = (function plumbing$core$interleave_all(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5257 = arguments.length;
var i__4737__auto___5258 = (0);
while(true){
if((i__4737__auto___5258 < len__4736__auto___5257)){
args__4742__auto__.push((arguments[i__4737__auto___5258]));

var G__5259 = (i__4737__auto___5258 + (1));
i__4737__auto___5258 = G__5259;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (colls){
return (new cljs.core.LazySeq(null,(function (){
return (function plumbing$core$helper(seqs){
if(cljs.core.seq.call(null,seqs)){
return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){
return plumbing$core$helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else {
return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
}));

(plumbing.core.interleave_all.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(plumbing.core.interleave_all.cljs$lang$applyTo = (function (seq5256){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq5256));
}));

/**
 * Returns # of elements of xs where pred holds
 */
plumbing.core.count_when = (function plumbing$core$count_when(pred,xs){
return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
 * Like conj but ignores non-truthy values
 */
plumbing.core.conj_when = (function plumbing$core$conj_when(var_args){
var G__5264 = arguments.length;
switch (G__5264) {
case 2:
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___5266 = arguments.length;
var i__4737__auto___5267 = (0);
while(true){
if((i__4737__auto___5267 < len__4736__auto___5266)){
args_arr__4757__auto__.push((arguments[i__4737__auto___5267]));

var G__5268 = (i__4737__auto___5267 + (1));
i__4737__auto___5267 = G__5268;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((2)),(0),null));
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4758__auto__);

}
});

(plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(cljs.core.truth_(x)){
return cljs.core.conj.call(null,coll,x);
} else {
return coll;
}
}));

(plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__5269 = plumbing.core.conj_when.call(null,coll,x);
var G__5270 = cljs.core.first.call(null,xs);
var G__5271 = cljs.core.next.call(null,xs);
coll = G__5269;
x = G__5270;
xs = G__5271;
continue;
} else {
return plumbing.core.conj_when.call(null,coll,x);
}
break;
}
}));

/** @this {Function} */
(plumbing.core.conj_when.cljs$lang$applyTo = (function (seq5261){
var G__5262 = cljs.core.first.call(null,seq5261);
var seq5261__$1 = cljs.core.next.call(null,seq5261);
var G__5263 = cljs.core.first.call(null,seq5261__$1);
var seq5261__$2 = cljs.core.next.call(null,seq5261__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5262,G__5263,seq5261__$2);
}));

(plumbing.core.conj_when.cljs$lang$maxFixedArity = (2));

/**
 * Like cons but does nothing if x is non-truthy.
 */
plumbing.core.cons_when = (function plumbing$core$cons_when(x,s){
if(cljs.core.truth_(x)){
return cljs.core.cons.call(null,x,s);
} else {
return s;
}
});
/**
 * Like sort-by, but prefers higher values rather than lower ones.
 */
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
 * Like swap! but returns a pair [old-val new-val]
 */
plumbing.core.swap_pair_BANG_ = (function plumbing$core$swap_pair_BANG_(var_args){
var G__5277 = arguments.length;
switch (G__5277) {
case 2:
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___5279 = arguments.length;
var i__4737__auto___5280 = (0);
while(true){
if((i__4737__auto___5280 < len__4736__auto___5279)){
args_arr__4757__auto__.push((arguments[i__4737__auto___5280]));

var G__5281 = (i__4737__auto___5280 + (1));
i__4737__auto___5280 = G__5281;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((2)),(0),null));
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4758__auto__);

}
});

(plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
while(true){
var old_val = cljs.core.deref.call(null,a);
var new_val = f.call(null,old_val);
if(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else {
continue;
}
break;
}
}));

(plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,args){
return plumbing.core.swap_pair_BANG_.call(null,a,(function (p1__5272_SHARP_){
return cljs.core.apply.call(null,f,p1__5272_SHARP_,args);
}));
}));

/** @this {Function} */
(plumbing.core.swap_pair_BANG_.cljs$lang$applyTo = (function (seq5274){
var G__5275 = cljs.core.first.call(null,seq5274);
var seq5274__$1 = cljs.core.next.call(null,seq5274);
var G__5276 = cljs.core.first.call(null,seq5274__$1);
var seq5274__$2 = cljs.core.next.call(null,seq5274__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5275,G__5276,seq5274__$2);
}));

(plumbing.core.swap_pair_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Like reset! but returns old-val
 */
plumbing.core.get_and_set_BANG_ = (function plumbing$core$get_and_set_BANG_(a,new_val){
return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function plumbing$core$millis(){
return (new Date()).getTime();
});
/**
 * Like apply, but applies a map to a function with positional map
 *   arguments. Can take optional initial args just like apply.
 */
plumbing.core.mapply = (function plumbing$core$mapply(var_args){
var G__5286 = arguments.length;
switch (G__5286) {
case 2:
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___5288 = arguments.length;
var i__4737__auto___5289 = (0);
while(true){
if((i__4737__auto___5289 < len__4736__auto___5288)){
args_arr__4757__auto__.push((arguments[i__4737__auto___5289]));

var G__5290 = (i__4737__auto___5289 + (1));
i__4737__auto___5289 = G__5290;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((2)),(0),null));
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4758__auto__);

}
});

(plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2 = (function (f,m){
return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
}));

(plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg,args){
return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
}));

/** @this {Function} */
(plumbing.core.mapply.cljs$lang$applyTo = (function (seq5283){
var G__5284 = cljs.core.first.call(null,seq5283);
var seq5283__$1 = cljs.core.next.call(null,seq5283);
var G__5285 = cljs.core.first.call(null,seq5283__$1);
var seq5283__$2 = cljs.core.next.call(null,seq5283__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5284,G__5285,seq5283__$2);
}));

(plumbing.core.mapply.cljs$lang$maxFixedArity = (2));


//# sourceMappingURL=core.js.map?rel=1598625890462
