// Compiled by ClojureScript 1.10.773 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR__orig_val__6558 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__6559 = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__6559);

try{try{var seq__6560 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__6561 = null;
var count__6562 = (0);
var i__6563 = (0);
while(true){
if((i__6563 < count__6562)){
var vec__6570 = cljs.core._nth.call(null,chunk__6561,i__6563);
var effect_key = cljs.core.nth.call(null,vec__6570,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6570,(1),null);
var temp__5733__auto___6592 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___6592)){
var effect_fn_6593 = temp__5733__auto___6592;
effect_fn_6593.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6594 = seq__6560;
var G__6595 = chunk__6561;
var G__6596 = count__6562;
var G__6597 = (i__6563 + (1));
seq__6560 = G__6594;
chunk__6561 = G__6595;
count__6562 = G__6596;
i__6563 = G__6597;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6560);
if(temp__5735__auto__){
var seq__6560__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6560__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6560__$1);
var G__6598 = cljs.core.chunk_rest.call(null,seq__6560__$1);
var G__6599 = c__4556__auto__;
var G__6600 = cljs.core.count.call(null,c__4556__auto__);
var G__6601 = (0);
seq__6560 = G__6598;
chunk__6561 = G__6599;
count__6562 = G__6600;
i__6563 = G__6601;
continue;
} else {
var vec__6573 = cljs.core.first.call(null,seq__6560__$1);
var effect_key = cljs.core.nth.call(null,vec__6573,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6573,(1),null);
var temp__5733__auto___6602 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___6602)){
var effect_fn_6603 = temp__5733__auto___6602;
effect_fn_6603.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6604 = cljs.core.next.call(null,seq__6560__$1);
var G__6605 = null;
var G__6606 = (0);
var G__6607 = (0);
seq__6560 = G__6604;
chunk__6561 = G__6605;
count__6562 = G__6606;
i__6563 = G__6607;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__6367__auto___6608 = re_frame.interop.now.call(null);
var duration__6368__auto___6609 = (end__6367__auto___6608 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__6368__auto___6609,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__6367__auto___6608);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__6558);
}} else {
var seq__6576 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__6577 = null;
var count__6578 = (0);
var i__6579 = (0);
while(true){
if((i__6579 < count__6578)){
var vec__6586 = cljs.core._nth.call(null,chunk__6577,i__6579);
var effect_key = cljs.core.nth.call(null,vec__6586,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6586,(1),null);
var temp__5733__auto___6610 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___6610)){
var effect_fn_6611 = temp__5733__auto___6610;
effect_fn_6611.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6612 = seq__6576;
var G__6613 = chunk__6577;
var G__6614 = count__6578;
var G__6615 = (i__6579 + (1));
seq__6576 = G__6612;
chunk__6577 = G__6613;
count__6578 = G__6614;
i__6579 = G__6615;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6576);
if(temp__5735__auto__){
var seq__6576__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6576__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6576__$1);
var G__6616 = cljs.core.chunk_rest.call(null,seq__6576__$1);
var G__6617 = c__4556__auto__;
var G__6618 = cljs.core.count.call(null,c__4556__auto__);
var G__6619 = (0);
seq__6576 = G__6616;
chunk__6577 = G__6617;
count__6578 = G__6618;
i__6579 = G__6619;
continue;
} else {
var vec__6589 = cljs.core.first.call(null,seq__6576__$1);
var effect_key = cljs.core.nth.call(null,vec__6589,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6589,(1),null);
var temp__5733__auto___6620 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___6620)){
var effect_fn_6621 = temp__5733__auto___6620;
effect_fn_6621.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6622 = cljs.core.next.call(null,seq__6576__$1);
var G__6623 = null;
var G__6624 = (0);
var G__6625 = (0);
seq__6576 = G__6622;
chunk__6577 = G__6623;
count__6578 = G__6624;
i__6579 = G__6625;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__6626 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__6627 = null;
var count__6628 = (0);
var i__6629 = (0);
while(true){
if((i__6629 < count__6628)){
var map__6634 = cljs.core._nth.call(null,chunk__6627,i__6629);
var map__6634__$1 = (((((!((map__6634 == null))))?(((((map__6634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6634.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6634):map__6634);
var effect = map__6634__$1;
var ms = cljs.core.get.call(null,map__6634__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__6634__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__6626,chunk__6627,count__6628,i__6629,map__6634,map__6634__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__6626,chunk__6627,count__6628,i__6629,map__6634,map__6634__$1,effect,ms,dispatch))
,ms);
}


var G__6638 = seq__6626;
var G__6639 = chunk__6627;
var G__6640 = count__6628;
var G__6641 = (i__6629 + (1));
seq__6626 = G__6638;
chunk__6627 = G__6639;
count__6628 = G__6640;
i__6629 = G__6641;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6626);
if(temp__5735__auto__){
var seq__6626__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6626__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6626__$1);
var G__6642 = cljs.core.chunk_rest.call(null,seq__6626__$1);
var G__6643 = c__4556__auto__;
var G__6644 = cljs.core.count.call(null,c__4556__auto__);
var G__6645 = (0);
seq__6626 = G__6642;
chunk__6627 = G__6643;
count__6628 = G__6644;
i__6629 = G__6645;
continue;
} else {
var map__6636 = cljs.core.first.call(null,seq__6626__$1);
var map__6636__$1 = (((((!((map__6636 == null))))?(((((map__6636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6636):map__6636);
var effect = map__6636__$1;
var ms = cljs.core.get.call(null,map__6636__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__6636__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__6626,chunk__6627,count__6628,i__6629,map__6636,map__6636__$1,effect,ms,dispatch,seq__6626__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__6626,chunk__6627,count__6628,i__6629,map__6636,map__6636__$1,effect,ms,dispatch,seq__6626__$1,temp__5735__auto__))
,ms);
}


var G__6646 = cljs.core.next.call(null,seq__6626__$1);
var G__6647 = null;
var G__6648 = (0);
var G__6649 = (0);
seq__6626 = G__6646;
chunk__6627 = G__6647;
count__6628 = G__6648;
i__6629 = G__6649;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value);
} else {
var seq__6650 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__6651 = null;
var count__6652 = (0);
var i__6653 = (0);
while(true){
if((i__6653 < count__6652)){
var event = cljs.core._nth.call(null,chunk__6651,i__6653);
re_frame.router.dispatch.call(null,event);


var G__6654 = seq__6650;
var G__6655 = chunk__6651;
var G__6656 = count__6652;
var G__6657 = (i__6653 + (1));
seq__6650 = G__6654;
chunk__6651 = G__6655;
count__6652 = G__6656;
i__6653 = G__6657;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6650);
if(temp__5735__auto__){
var seq__6650__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6650__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6650__$1);
var G__6658 = cljs.core.chunk_rest.call(null,seq__6650__$1);
var G__6659 = c__4556__auto__;
var G__6660 = cljs.core.count.call(null,c__4556__auto__);
var G__6661 = (0);
seq__6650 = G__6658;
chunk__6651 = G__6659;
count__6652 = G__6660;
i__6653 = G__6661;
continue;
} else {
var event = cljs.core.first.call(null,seq__6650__$1);
re_frame.router.dispatch.call(null,event);


var G__6662 = cljs.core.next.call(null,seq__6650__$1);
var G__6663 = null;
var G__6664 = (0);
var G__6665 = (0);
seq__6650 = G__6662;
chunk__6651 = G__6663;
count__6652 = G__6664;
i__6653 = G__6665;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__6666 = cljs.core.seq.call(null,value);
var chunk__6667 = null;
var count__6668 = (0);
var i__6669 = (0);
while(true){
if((i__6669 < count__6668)){
var event = cljs.core._nth.call(null,chunk__6667,i__6669);
clear_event.call(null,event);


var G__6670 = seq__6666;
var G__6671 = chunk__6667;
var G__6672 = count__6668;
var G__6673 = (i__6669 + (1));
seq__6666 = G__6670;
chunk__6667 = G__6671;
count__6668 = G__6672;
i__6669 = G__6673;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6666);
if(temp__5735__auto__){
var seq__6666__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6666__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6666__$1);
var G__6674 = cljs.core.chunk_rest.call(null,seq__6666__$1);
var G__6675 = c__4556__auto__;
var G__6676 = cljs.core.count.call(null,c__4556__auto__);
var G__6677 = (0);
seq__6666 = G__6674;
chunk__6667 = G__6675;
count__6668 = G__6676;
i__6669 = G__6677;
continue;
} else {
var event = cljs.core.first.call(null,seq__6666__$1);
clear_event.call(null,event);


var G__6678 = cljs.core.next.call(null,seq__6666__$1);
var G__6679 = null;
var G__6680 = (0);
var G__6681 = (0);
seq__6666 = G__6678;
chunk__6667 = G__6679;
count__6668 = G__6680;
i__6669 = G__6681;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref.call(null,re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1598625891801
