// Compiled by ClojureScript 1.10.773 {}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.call(null,(0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_.call(null,re_frame.trace.id,(0));
});

/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.call(null,(0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(cljs.core.truth_(re_frame.trace.trace_enabled_QMARK_)){
return cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation.");
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.call(null,re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__6389){
var map__6390 = p__6389;
var map__6390__$1 = (((((!((map__6390 == null))))?(((((map__6390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6390.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6390):map__6390);
var operation = cljs.core.get.call(null,map__6390__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.call(null,map__6390__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.call(null,map__6390__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.call(null,map__6390__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id.call(null),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4126__auto__ = child_of;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now.call(null)], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce.call(null,(function re_frame$trace$tracing_cb_debounced(){
var seq__6392_6412 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__6393_6413 = null;
var count__6394_6414 = (0);
var i__6395_6415 = (0);
while(true){
if((i__6395_6415 < count__6394_6414)){
var vec__6404_6416 = cljs.core._nth.call(null,chunk__6393_6413,i__6395_6415);
var k_6417 = cljs.core.nth.call(null,vec__6404_6416,(0),null);
var cb_6418 = cljs.core.nth.call(null,vec__6404_6416,(1),null);
try{cb_6418.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e6407){var e_6419 = e6407;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_6417,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_6419);
}

var G__6420 = seq__6392_6412;
var G__6421 = chunk__6393_6413;
var G__6422 = count__6394_6414;
var G__6423 = (i__6395_6415 + (1));
seq__6392_6412 = G__6420;
chunk__6393_6413 = G__6421;
count__6394_6414 = G__6422;
i__6395_6415 = G__6423;
continue;
} else {
var temp__5735__auto___6424 = cljs.core.seq.call(null,seq__6392_6412);
if(temp__5735__auto___6424){
var seq__6392_6425__$1 = temp__5735__auto___6424;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6392_6425__$1)){
var c__4556__auto___6426 = cljs.core.chunk_first.call(null,seq__6392_6425__$1);
var G__6427 = cljs.core.chunk_rest.call(null,seq__6392_6425__$1);
var G__6428 = c__4556__auto___6426;
var G__6429 = cljs.core.count.call(null,c__4556__auto___6426);
var G__6430 = (0);
seq__6392_6412 = G__6427;
chunk__6393_6413 = G__6428;
count__6394_6414 = G__6429;
i__6395_6415 = G__6430;
continue;
} else {
var vec__6408_6431 = cljs.core.first.call(null,seq__6392_6425__$1);
var k_6432 = cljs.core.nth.call(null,vec__6408_6431,(0),null);
var cb_6433 = cljs.core.nth.call(null,vec__6408_6431,(1),null);
try{cb_6433.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e6411){var e_6434 = e6411;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_6432,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_6434);
}

var G__6435 = cljs.core.next.call(null,seq__6392_6425__$1);
var G__6436 = null;
var G__6437 = (0);
var G__6438 = (0);
seq__6392_6412 = G__6435;
chunk__6393_6413 = G__6436;
count__6394_6414 = G__6437;
i__6395_6415 = G__6438;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref.call(null,re_frame.trace.next_delivery) - (25)) < now)){
re_frame.trace.schedule_debounce.call(null);

return cljs.core.reset_BANG_.call(null,re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=trace.js.map?rel=1598625891565
