/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Vector;
import netP5.AbstractTcpClient;
import netP5.Logger;
import netP5.TcpClient;
import netP5.TcpPacket;
import netP5.TcpPacketListener;

public abstract class AbstractTcpServer
implements Runnable,
TcpPacketListener {
    protected ServerSocket _myServerSocket;
    protected static int _myPort;
    protected TcpPacketListener _myTcpPacketListener = null;
    protected Vector _myTcpClients;
    protected Thread _myThread;
    public static final int MODE_READLINE = 0;
    public static final int MODE_TERMINATED = 1;
    public static final int MODE_NEWLINE = 2;
    public static final int MODE_STREAM = 3;
    protected final int _myMode;
    protected Vector _myBanList;

    public AbstractTcpServer(int thePort, int theMode) {
        _myPort = thePort;
        this._myMode = theMode;
        this._myTcpPacketListener = this;
        this.init();
    }

    public AbstractTcpServer(TcpPacketListener theTcpPacketListener, int thePort, int theMode) {
        _myPort = thePort;
        this._myMode = theMode;
        this._myTcpPacketListener = theTcpPacketListener;
        this.init();
    }

    protected void init() {
        this._myBanList = new Vector();
        this._myServerSocket = null;
        this._myTcpClients = new Vector();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            Logger.printError("TcpServer.start()", "TcpServer sleep interuption " + iex);
            return;
        }
        try {
            this._myServerSocket = new ServerSocket(_myPort);
        }
        catch (IOException e) {
            Logger.printError("TcpServer.start()", "TcpServer io Exception " + e);
            return;
        }
        this._myThread = new Thread(this);
        this._myThread.start();
        Logger.printProcess("TcpServer", "ServerSocket started @ " + _myPort);
    }

    public void ban(String theIP) {
        this._myBanList.add(theIP);
        for (int i = this._myTcpClients.size() - 1; i >= 0; --i) {
            if (!((TcpClient)this._myTcpClients.get(i)).netAddress().address().equals(theIP)) continue;
            ((TcpClient)this._myTcpClients.get(i)).dispose();
        }
    }

    public void unBan(String theIP) {
        this._myBanList.remove(theIP);
    }

    private boolean checkBanList(ServerSocket theSocket) {
        try {
            String mySocketAddress = theSocket.getInetAddress().getHostAddress();
            String mySocketName = theSocket.getInetAddress().getHostName();
            for (int i = this._myBanList.size() - 1; i >= 0; --i) {
                if (!mySocketAddress.equals(this._myBanList.get(i)) && !mySocketName.equals(this._myBanList.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ServerSocket socket() {
        return this._myServerSocket;
    }

    public void run() {
        while (Thread.currentThread() == this._myThread) {
            try {
                if (!this.checkBanList(this._myServerSocket)) continue;
                TcpClient t = new TcpClient(this, this._myServerSocket.accept(), this._myTcpPacketListener, _myPort, this._myMode);
                System.out.println("### new Client @ " + t);
                this._myTcpClients.addElement(t);
                Logger.printProcess("TcpServer.run", this._myTcpClients.size() + " currently running.");
            }
            catch (IOException e) {
                Logger.printError("TcpServer", "IOException. Stopping server.");
                break;
            }
        }
        this.dispose();
    }

    public synchronized void send(String theString) {
        try {
            Enumeration en = this._myTcpClients.elements();
            while (en.hasMoreElements()) {
                ((TcpClient)en.nextElement()).send(theString);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public synchronized void send(byte[] theBytes) {
        try {
            Enumeration en = this._myTcpClients.elements();
            while (en.hasMoreElements()) {
                ((TcpClient)en.nextElement()).send(theBytes);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this._myThread = null;
            if (this._myTcpClients != null) {
                Enumeration en = this._myTcpClients.elements();
                while (en.hasMoreElements()) {
                    this.remove((TcpClient)en.nextElement());
                }
                this._myTcpClients = null;
            }
            if (this._myServerSocket != null) {
                this._myServerSocket.close();
                this._myServerSocket = null;
            }
        }
        catch (IOException e) {
            Logger.printError("TcpServer.dispose", "IOException " + e);
        }
    }

    public int size() {
        return this._myTcpClients.size();
    }

    public TcpClient[] getClients() {
        TcpClient[] s = new TcpClient[this._myTcpClients.size()];
        this._myTcpClients.toArray(s);
        return s;
    }

    public TcpClient getClient(int theIndex) {
        return (TcpClient)this._myTcpClients.elementAt(theIndex);
    }

    public void process(TcpPacket thePacket, int thePort) {
        this.handleInput(thePacket, thePort);
    }

    public abstract void handleInput(TcpPacket var1, int var2);

    public void remove(AbstractTcpClient theTcpClient) {
        if (this._myTcpPacketListener != null && !this._myTcpPacketListener.equals(this)) {
            this._myTcpPacketListener.remove(theTcpClient);
        }
        theTcpClient.dispose();
        this._myTcpClients.removeElement(theTcpClient);
        Logger.printProcess("TcpServer", "removing TcpClient.");
    }
}

