/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.net.DatagramPacket;
import java.net.InetAddress;
import netP5.TcpClient;
import netP5.TcpPacket;

public class NetMessage {
    private InetAddress _myInetAddress;
    private int _myPort;
    private String _myString = "";
    private byte[] _myData = new byte[0];
    private TcpClient _myTcpClient;
    private boolean isDatagramPacket = false;
    private int _myProtocol;
    private DatagramPacket _myDatagramPacket;
    private TcpPacket _myTcpPacket;

    protected NetMessage(DatagramPacket theDatagramPacket) {
        this._myDatagramPacket = theDatagramPacket;
        this._myInetAddress = theDatagramPacket.getAddress();
        this._myPort = theDatagramPacket.getPort();
        this._myData = theDatagramPacket.getData();
        this._myProtocol = 0;
        this.isDatagramPacket = true;
    }

    protected NetMessage(TcpPacket theTcpPacket) {
        this._myTcpPacket = theTcpPacket;
        this._myInetAddress = theTcpPacket.getTcpConnection().socket().getInetAddress();
        this._myPort = theTcpPacket.getTcpConnection().socket().getPort();
        this._myString = theTcpPacket.getTcpConnection().getString();
        this._myData = theTcpPacket.getData();
        this._myProtocol = 2;
        this._myTcpClient = theTcpPacket.getTcpConnection();
    }

    public TcpPacket getTcpPacket() {
        return this._myTcpPacket;
    }

    public DatagramPacket getDatagramPacket() {
        return this._myDatagramPacket;
    }

    protected void setProtocol(int theType) {
        this._myProtocol = theType;
    }

    public byte[] getData() {
        return this._myData;
    }

    public String getString() {
        if (this.isDatagramPacket) {
            return new String(this._myData);
        }
        return this._myString;
    }

    public int protocol() {
        return this._myProtocol;
    }

    public int port() {
        return this._myPort;
    }

    public TcpClient tcpConnection() {
        return this._myTcpClient;
    }

    public String address() {
        return this._myInetAddress.getHostAddress();
    }

    public InetAddress inetAddress() {
        return this._myInetAddress;
    }
}

