/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.net.Socket;
import netP5.AbstractTcpClient;
import netP5.AbstractTcpServer;
import netP5.Logger;
import netP5.NetAddress;
import netP5.NetPlug;
import netP5.TcpPacket;
import netP5.TcpPacketListener;

public class TcpClient
extends AbstractTcpClient {
    protected static final int NULL = -1;
    protected static final int LISTENER = 0;
    protected static final int EVENT = 1;
    private int _myMode = -1;
    private Object _myParent;
    private NetPlug _myNetPlug;
    private String _myName = "";

    public TcpClient(Object theObject, String theAddress, int thePort) {
        super(theAddress, thePort);
        this._myParent = theObject;
        this.initEvent();
    }

    public TcpClient(Object theObject, String theAddress, int thePort, int theMode) {
        super(theAddress, thePort, theMode);
        this._myParent = theObject;
        this.initEvent();
    }

    public TcpClient(TcpPacketListener theListener, String theServerAddress, int theServerPort, int theMode) {
        super(theListener, theServerAddress, theServerPort, theMode);
        this._myMode = 0;
    }

    public TcpClient(Object theObject, NetAddress theNetAddress) {
        super(theNetAddress.address(), theNetAddress.port());
        this._myParent = theObject;
        this.initEvent();
    }

    public TcpClient(NetAddress theNetAddress) {
        super(theNetAddress.address(), theNetAddress.port());
    }

    public TcpClient(String theAddress, int thePort) {
        super(theAddress, thePort);
    }

    public TcpClient(AbstractTcpServer theTcpServer, Socket theSocket, TcpPacketListener theTcpPacketListener, int theServerPort, int theMode) {
        super(theTcpServer, theSocket, theTcpPacketListener, theServerPort, theMode);
        this._myMode = 0;
    }

    private void initEvent() {
        this._myMode = 1;
        this._myNetPlug = new NetPlug(this._myParent);
    }

    public void handleStatus(int theIndex) {
        switch (this._myMode) {
            case 1: {
                this._myNetPlug.status(theIndex);
                break;
            }
            case 0: {
                this._myTcpPacketListener.status(theIndex);
                break;
            }
            case -1: {
                Logger.printDebug("TcpClient.handleStatus()", "net status id " + theIndex);
            }
        }
    }

    public void handleInput() {
        switch (this._myMode) {
            case 1: {
                this._myNetPlug.process(new TcpPacket(this, this._myStringBuffer, this._myBytes), this._myServerPort);
                break;
            }
            case 0: {
                this._myTcpPacketListener.process(new TcpPacket(this, this._myStringBuffer, this._myBytes), this._myServerPort);
                break;
            }
            case -1: {
                Logger.printDebug("TcpClient.handleInput()", "received a message : " + this._myStringBuffer.toString());
            }
        }
    }

    public String name() {
        return this._myName;
    }

    public void setName(String theName) {
        this._myName = theName;
    }
}

