/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import netP5.AbstractTcpClient;
import netP5.Logger;
import netP5.NetAddress;
import netP5.NetAddressList;
import netP5.NetInfo;
import netP5.TcpClient;
import netP5.TcpPacket;
import netP5.TcpPacketListener;
import netP5.TcpServer;
import netP5.UdpPacketListener;
import oscP5.OscBundle;
import oscP5.OscEventListener;
import oscP5.OscIn;
import oscP5.OscMessage;
import oscP5.OscNetManager;
import oscP5.OscPacket;
import oscP5.OscPlug;
import oscP5.OscProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OscP5
implements UdpPacketListener,
TcpPacketListener {
    protected HashMap<String, ArrayList<OscPlug>> _myOscPlugMap = new HashMap();
    protected NetInfo _myNetInfo;
    private OscNetManager _myOscNetManager;
    protected static final int NONE = 0;
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final int UDP = 0;
    public static final int MULTICAST = 1;
    public static final int TCP = 2;
    protected final Object parent;
    private OscProperties _myOscProperties;
    private Class<?> _myParentClass;
    private Method _myEventMethod;
    private Class<?> _myEventClass = OscMessage.class;
    private boolean isEventMethod;
    private boolean isBroadcast = false;
    private NetAddress _myBroadcastAddress;
    private boolean isOscIn = false;
    public static final String VERSION = "##version##";

    public OscP5(Object theParent, OscProperties theProperties) {
        this.welcome();
        this.parent = theParent;
        this.registerDispose(this.parent);
        this._myOscProperties = theProperties;
        this._myOscNetManager = new OscNetManager();
        this._myOscNetManager.start(this._myOscProperties);
        if (this._myOscProperties.networkProtocol() == 2) {
            this._myOscNetManager.addTcpListener(this);
        } else {
            this._myOscNetManager.addUdpListener(this);
        }
        this.isEventMethod = this.checkEventMethod();
        if (this._myOscProperties.networkProtocol() == 1) {
            Logger.printInfo("OscP5", "is joining a multicast group @ " + this._myOscProperties.remoteAddress().address() + ":" + this._myOscProperties.remoteAddress().port());
        } else {
            Logger.printInfo("OscP5", "is running. you (" + this.ip() + ") are listening @ port " + this._myOscProperties.remoteAddress().port());
        }
    }

    public OscP5(Object theParent, String theAddress, int thePort, int theMode) {
        this.welcome();
        this.parent = theParent;
        this._myOscProperties = new OscProperties();
        this.registerDispose(this.parent);
        switch (theMode) {
            case 1: {
                this._myOscProperties.setNetworkProtocol(1);
                this._myOscProperties.setRemoteAddress(theAddress, thePort);
                this._myOscProperties.setListeningPort(thePort);
                this._myOscNetManager = new OscNetManager();
                this._myOscNetManager.start(this._myOscProperties);
                this._myOscNetManager.addUdpListener(this);
                Logger.printInfo("OscP5", "is joining a multicast group @ " + this._myOscProperties.remoteAddress().address() + ":" + this._myOscProperties.remoteAddress().port());
                break;
            }
            case 0: {
                this._myOscProperties.setRemoteAddress(theAddress, thePort);
                this.initUDP(thePort);
                break;
            }
            case 2: {
                this._myOscProperties.setNetworkProtocol(2);
                this._myOscProperties.setRemoteAddress(theAddress, thePort);
                this._myOscNetManager = new OscNetManager();
                this._myOscNetManager.start(this._myOscProperties);
                this._myOscNetManager.addTcpListener(this);
            }
        }
        this.isEventMethod = this.checkEventMethod();
    }

    public OscP5(Object theParent, int theReceiveAtPort, int theMode) {
        this.welcome();
        this.parent = theParent;
        this.registerDispose(this.parent);
        this._myOscProperties = new OscProperties();
        switch (theMode) {
            case 0: {
                this.initUDP(theReceiveAtPort);
                break;
            }
            case 2: {
                this._myOscProperties.setNetworkProtocol(2);
                this._myOscProperties.setListeningPort(theReceiveAtPort);
                this._myOscNetManager = new OscNetManager();
                this._myOscNetManager.start(this._myOscProperties);
                this._myOscNetManager.addTcpListener(this);
                break;
            }
            case 1: {
                Logger.printWarning("OscP5", "please specify a multicast address. use OscP5(Object theObject, String theMulticastAddress, int thePort, int theMode)");
            }
        }
        this.isEventMethod = this.checkEventMethod();
    }

    public OscP5(Object theParent, int theReceiveAtPort) {
        this.welcome();
        this.parent = theParent;
        this.registerDispose(this.parent);
        this.initUDP(theReceiveAtPort);
        this.isEventMethod = this.checkEventMethod();
    }

    private void welcome() {
        System.out.println("OscP5 ##version## infos, comments, questions at http://www.sojamo.de/oscP5\n\n");
    }

    private void registerDispose(Object theObject) {
        try {
            Object parent = null;
            String child = "processing.core.PApplet";
            try {
                Class<?> childClass = Class.forName(child);
                Class<Object> parentClass = Object.class;
                if (parentClass.isAssignableFrom(childClass)) {
                    parent = childClass.newInstance();
                    parent = theObject;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Method method = parent.getClass().getMethod("registerDispose", Object.class);
                try {
                    method.invoke(parent, this);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {}
        }
        catch (NullPointerException e) {
            System.err.println("Register Dispose\n" + e);
        }
    }

    private void initUDP(int theReceiveAtPort) {
        this._myOscProperties = new OscProperties();
        this._myOscProperties.setListeningPort(theReceiveAtPort);
        this._myOscNetManager = new OscNetManager();
        this._myOscNetManager.start(this._myOscProperties);
        this._myOscNetManager.addUdpListener(this);
        Logger.printInfo("OscP5", "is running. you (" + this.ip() + ") are listening @ port " + theReceiveAtPort);
    }

    private boolean checkEventMethod() {
        this._myParentClass = this.parent.getClass();
        try {
            Method[] myMethods = this._myParentClass.getDeclaredMethods();
            for (int i = 0; i < myMethods.length; ++i) {
                Class<?>[] myClasses;
                if (myMethods[i].getName().indexOf(this._myOscProperties.eventMethod()) == -1 || (myClasses = myMethods[i].getParameterTypes()).length != 1) continue;
                this._myEventClass = myClasses[0];
                this.isOscIn = this._myEventClass.toString().indexOf("OscIn") != -1;
                break;
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        String tMethod = this._myOscProperties.eventMethod();
        if (tMethod != null) {
            try {
                Class[] tClass = new Class[]{this._myEventClass};
                this._myEventMethod = this._myParentClass.getDeclaredMethod(tMethod, tClass);
                this._myEventMethod.setAccessible(true);
                return true;
            }
            catch (SecurityException e1) {
                Logger.printWarning("OscP5.plug", "### security issues in OscP5.checkEventMethod(). (this occures when running in applet mode)");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this._myEventMethod != null;
    }

    public String version() {
        return VERSION;
    }

    public void dispose() {
        this.stop();
    }

    public void addListener(OscEventListener theListener) {
        this._myOscProperties.listeners().add(theListener);
    }

    public void removeListener(OscEventListener theListener) {
        this._myOscProperties.listeners().remove(theListener);
    }

    public Vector<OscEventListener> listeners() {
        return this._myOscProperties.listeners();
    }

    public void plug(Object theObject, String theMethodName, String theAddrPattern, String theTypeTag) {
        OscPlug myOscPlug = new OscPlug();
        myOscPlug.plug(theObject, theMethodName, theAddrPattern, theTypeTag);
        if (this._myOscPlugMap.containsKey(theAddrPattern)) {
            this._myOscPlugMap.get(theAddrPattern).add(myOscPlug);
        } else {
            ArrayList<OscPlug> myOscPlugList = new ArrayList<OscPlug>();
            myOscPlugList.add(myOscPlug);
            this._myOscPlugMap.put(theAddrPattern, myOscPlugList);
        }
    }

    public void plug(Object theObject, String theMethodName, String theAddrPattern) {
        Class<?> myClass = theObject.getClass();
        Method[] myMethods = myClass.getDeclaredMethods();
        Class<?>[] myParams = null;
        for (int i = 0; i < myMethods.length; ++i) {
            String myTypetag = "";
            try {
                myMethods[i].setAccessible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!myMethods[i].getName().equals(theMethodName)) continue;
            myParams = myMethods[i].getParameterTypes();
            OscPlug myOscPlug = new OscPlug();
            for (int j = 0; j < myParams.length; ++j) {
                myTypetag = myTypetag + myOscPlug.checkType(myParams[j].getName());
            }
            myOscPlug.plug(theObject, theMethodName, theAddrPattern, myTypetag);
            if (this._myOscPlugMap.containsKey(theAddrPattern)) {
                this._myOscPlugMap.get(theAddrPattern).add(myOscPlug);
                continue;
            }
            ArrayList<OscPlug> myOscPlugList = new ArrayList<OscPlug>();
            myOscPlugList.add(myOscPlug);
            this._myOscPlugMap.put(theAddrPattern, myOscPlugList);
        }
    }

    private void handleSystemMessage(OscMessage theOscMessage) {
        if (theOscMessage.addrPattern().startsWith("/sys/ping")) {
            this.send("/sys/pong", new Object[0], this._myBroadcastAddress);
        } else if (theOscMessage.addrPattern().startsWith("/sys/register") && theOscMessage.tcpConnection() != null && theOscMessage.checkTypetag("s")) {
            theOscMessage.tcpConnection().setName(theOscMessage.get(0).stringValue());
        }
    }

    private void callMethod(OscMessage theOscMessage) {
        OscPlug myPlug;
        int i;
        if (theOscMessage.addrPattern().startsWith("/sys/")) {
            this.handleSystemMessage(theOscMessage);
        }
        for (int i2 = this.listeners().size() - 1; i2 >= 0; --i2) {
            this.listeners().get(i2).oscEvent(theOscMessage);
        }
        if (theOscMessage.isArray && this._myOscPlugMap.containsKey(theOscMessage.addrPattern())) {
            ArrayList<OscPlug> myOscPlugList = this._myOscPlugMap.get(theOscMessage.addrPattern());
            for (i = 0; i < myOscPlugList.size(); ++i) {
                myPlug = myOscPlugList.get(i);
                if (!myPlug.isArray || !myPlug.checkMethod(theOscMessage, true)) continue;
                this.invoke(myPlug.getObject(), myPlug.getMethod(), theOscMessage.argsAsArray());
            }
        }
        if (this._myOscPlugMap.containsKey(theOscMessage.addrPattern())) {
            ArrayList<OscPlug> myOscPlugList = this._myOscPlugMap.get(theOscMessage.addrPattern());
            for (i = 0; i < myOscPlugList.size(); ++i) {
                myPlug = myOscPlugList.get(i);
                if (myPlug.isArray || !myPlug.checkMethod(theOscMessage, false)) continue;
                theOscMessage.isPlugged = true;
                this.invoke(myPlug.getObject(), myPlug.getMethod(), theOscMessage.arguments());
            }
        }
        Logger.printDebug("OscP5.callMethod ", "" + this.isEventMethod);
        if (this.isEventMethod) {
            try {
                if (this.isOscIn) {
                    this.invoke(this.parent, this._myEventMethod, new Object[]{new OscIn(theOscMessage)});
                    Logger.printDebug("OscP5.callMethod ", "invoking OscIn " + this.isEventMethod);
                } else {
                    this.invoke(this.parent, this._myEventMethod, new Object[]{theOscMessage});
                    Logger.printDebug("OscP5.callMethod ", "invoking OscMessage " + this.isEventMethod);
                }
            }
            catch (ClassCastException e) {
                Logger.printError("OscHandler.callMethod", " ClassCastException." + e);
            }
        }
    }

    private void invoke(Object theObject, Method theMethod, Object[] theArgs) {
        try {
            theMethod.invoke(theObject, theArgs);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Logger.printError("OscP5", "ERROR. an error occured while forwarding an OscMessage\n to a method in your program. please check your code for any \npossible errors that might occur in the method where incoming\n OscMessages are parsed e.g. check for casting errors, possible\n nullpointers, array overflows ... .\nmethod in charge : " + theMethod.getName() + "  " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DatagramPacket thePacket, int thePort) {
        OscP5 oscP5 = this;
        synchronized (oscP5) {
            OscPacket p = OscPacket.parse(thePacket);
            if (p.isValid()) {
                if (p.type() == 1) {
                    for (int i = 0; i < ((OscBundle)p).size(); ++i) {
                        this.callMethod(((OscBundle)p).getMessage(i));
                    }
                } else {
                    this.callMethod((OscMessage)p);
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TcpPacket thePacket, int thePort) {
        OscP5 oscP5 = this;
        synchronized (oscP5) {
            OscPacket p = OscPacket.parse(thePacket);
            if (p.isValid()) {
                if (p.type() == 1) {
                    for (int i = 0; i < ((OscBundle)p).size(); ++i) {
                        this.callMethod(((OscBundle)p).getMessage(i));
                    }
                } else {
                    this.callMethod((OscMessage)p);
                }
            }
            this.notifyAll();
        }
    }

    @Override
    public void remove(AbstractTcpClient theTcpClient) {
    }

    @Override
    public void status(int theIndex) {
    }

    public OscProperties properties() {
        return this._myOscProperties;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public String ip() {
        return NetInfo.getHostAddress();
    }

    public static void setLogStatus(int theIndex, int theValue) {
        Logger.set(theIndex, theValue);
    }

    public static void setLogStatus(int theValue) {
        for (int i = 0; i < 5; ++i) {
            Logger.set(i, theValue);
        }
    }

    public void setTimeToLive(int theTTL) {
        this._myOscNetManager.setTimeToLive(theTTL);
    }

    public void disconnect(NetAddress theHost) {
        if (theHost.isvalid() && theHost.name.length() > 1) {
            String myAddrPattern = "/sys/disconnect/" + theHost.name + "/" + theHost.port();
            this.send(myAddrPattern, new Object[0], theHost);
            this.isBroadcast = false;
            this._myBroadcastAddress = null;
        }
    }

    public void connect(NetAddress theNetAddress, String theName, String[] theArguments) {
        if (theNetAddress.isvalid()) {
            this._myBroadcastAddress = theNetAddress;
            this._myBroadcastAddress.name = theName;
            String myAddrPattern = "/sys/connect/" + theName + "/" + this._myOscProperties.listeningPort();
            this.send(myAddrPattern, (Object[])theArguments, this._myBroadcastAddress);
            this.isBroadcast = true;
        }
    }

    public NetInfo netInfo() {
        return this._myNetInfo;
    }

    public TcpServer tcpServer() {
        return this._myOscNetManager.tcpServer();
    }

    public TcpClient tcpClient() {
        return this._myOscNetManager.tcpClient();
    }

    public void send(OscPacket thePacket, NetAddress theNetAddress) {
        this._myOscNetManager.send(thePacket, theNetAddress);
    }

    public void send(OscPacket thePacket) {
        this._myOscNetManager.send(thePacket);
    }

    public void send(OscPacket thePacket, NetAddressList theNetAddressList) {
        this._myOscNetManager.send(thePacket, theNetAddressList);
    }

    public void send(String theAddrPattern, Object[] theArguments) {
        this._myOscNetManager.send(theAddrPattern, theArguments);
    }

    public void send(String theAddrPattern, Object[] theArguments, NetAddressList theNetAddressList) {
        this._myOscNetManager.send(theAddrPattern, theArguments, theNetAddressList);
    }

    public void send(String theAddrPattern, Object[] theArguments, NetAddress theNetAddress) {
        this._myOscNetManager.send(theAddrPattern, theArguments, theNetAddress);
    }

    public void send(String theAddrPattern, Object[] theArguments, String theAddress, int thePort) {
        this._myOscNetManager.send(theAddrPattern, theArguments, theAddress, thePort);
    }

    public void send(OscPacket thePacket, TcpClient theClient) {
        theClient.send(thePacket.getBytes());
    }

    public void send(String theAddrPattern, Object[] theArguments, TcpClient theClient) {
        this.send((OscPacket)new OscMessage(theAddrPattern, theArguments), theClient);
    }

    public void send(OscPacket thePacket, String theIpAddress, int thePort) {
        this._myOscNetManager.send(thePacket, theIpAddress, thePort);
    }

    public void stop() {
        Logger.printDebug("OscP5.stop", "starting to stop oscP5.");
        this._myOscNetManager.stop();
        Logger.printDebug("OscP5.stop", "stopping oscP5.");
    }

    public static void flush(OscMessage theOscMessage, NetAddress theNetAddress) {
        OscP5.flush(theOscMessage.getBytes(), theNetAddress);
    }

    public static void flush(OscPacket theOscPacket, NetAddress theNetAddress) {
        OscP5.flush(theOscPacket.getBytes(), theNetAddress);
    }

    public static void flush(String theAddrPattern, Object[] theArguments, NetAddress theNetAddress) {
        OscP5.flush(new OscMessage(theAddrPattern, theArguments).getBytes(), theNetAddress);
    }

    public static void flush(byte[] theBytes, NetAddress theNetAddress) {
        try {
            DatagramSocket mySocket = new DatagramSocket();
            DatagramPacket myPacket = new DatagramPacket(theBytes, theBytes.length, theNetAddress.inetaddress(), theNetAddress.port());
            mySocket.send(myPacket);
        }
        catch (SocketException e) {
            Logger.printError("OscP5.openSocket", "cant create socket " + e.getMessage());
        }
        catch (IOException e) {
            Logger.printError("OscP5.openSocket", "cant create multicastSocket " + e.getMessage());
        }
    }

    public static void flush(byte[] theBytes, String theAddress, int thePort) {
        OscP5.flush(theBytes, new NetAddress(theAddress, thePort));
    }

    public static void flush(OscMessage theOscMessage, String theAddress, int thePort) {
        OscP5.flush(theOscMessage.getBytes(), new NetAddress(theAddress, thePort));
    }

    public OscP5(Object theParent, String theHost, int theSendToPort, int theReceiveAtPort, String theMethodName) {
        this.welcome();
        this.parent = theParent;
        this.registerDispose(this.parent);
        this._myOscProperties = new OscProperties();
        this._myOscProperties.setRemoteAddress(theHost, theSendToPort);
        this._myOscProperties.setListeningPort(theReceiveAtPort);
        this._myOscProperties.setEventMethod(theMethodName);
        this._myOscNetManager = new OscNetManager();
        this._myOscNetManager.start(this._myOscProperties);
        this._myOscNetManager.addUdpListener(this);
        this.isEventMethod = this.checkEventMethod();
    }

    public OscMessage newMsg(String theAddrPattern) {
        return new OscMessage(theAddrPattern);
    }

    public OscBundle newBundle() {
        return new OscBundle();
    }

    public void disconnectFromTEMP() {
    }

    public OscP5(Object theParent, String theAddress, int thePort) {
        this(theParent, theAddress, thePort, 1);
    }
}

