/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.net.InetAddress;
import netP5.Bytes;
import netP5.NetAddress;
import netP5.TcpClient;
import netP5.TcpPacket;
import oscP5.OscBundle;
import oscP5.OscMessage;
import oscP5.OscPatcher;

public abstract class OscPacket
extends OscPatcher {
    protected static final int MESSAGE = 0;
    protected static final int BUNDLE = 1;
    protected InetAddress inetAddress;
    protected String hostAddress;
    protected int _myType;
    protected TcpClient _myTcpClient = null;
    protected int port;

    protected static OscPacket parse(DatagramPacket theDatagramPacket) {
        if (OscPacket.evaluatePacket(theDatagramPacket.getData()) == 0) {
            return new OscMessage(theDatagramPacket);
        }
        return new OscBundle(theDatagramPacket);
    }

    protected static OscPacket parse(TcpPacket theTcpPacket) {
        if (OscPacket.evaluatePacket(theTcpPacket.getData()) == 0) {
            return new OscMessage(theTcpPacket);
        }
        return new OscBundle(theTcpPacket);
    }

    private static int evaluatePacket(byte[] theBytes) {
        return Bytes.areEqual(OscBundle.BUNDLE_AS_BYTES, Bytes.copy(theBytes, 0, OscBundle.BUNDLE_AS_BYTES.length)) ? 1 : 0;
    }

    public TcpClient tcpConnection() {
        return this._myTcpClient;
    }

    protected boolean isValid() {
        return this.isValid;
    }

    protected int type() {
        return this._myType;
    }

    public int port() {
        return this.port;
    }

    public NetAddress netAddress() {
        return new NetAddress(this.inetAddress, this.port);
    }

    public NetAddress netaddress() {
        return new NetAddress(this.inetAddress, this.port);
    }

    public String address() {
        return this.hostAddress;
    }

    public abstract byte[] getBytes();
}

