/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.lang.reflect.Method;
import netP5.Logger;
import oscP5.OscMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OscPlug {
    private boolean _isValid = true;
    private String _myTypetag = "";
    private String _myAddrPattern = "";
    private String _myPattern = "";
    private String _myMethodName;
    private Object _myObject;
    public Method method = null;
    private int _myChecker = 0;
    protected boolean isArray = false;
    private static final int CHECK_ADDRPATTERN_TYPETAG = 0;
    private static final int CHECK_ADDRPATTERN = 1;
    private static final int CHECK_TYPETAG = 2;

    public void plug(Object theObject, String theMethodName, String theAddrPattern) {
        this._myObject = theObject;
        this._myMethodName = theMethodName;
        this._myAddrPattern = theAddrPattern;
        this._myChecker = 0;
        if (this._myMethodName != null && this._myMethodName.length() > 0) {
            Class<?> myClass = theObject.getClass();
            Class<?>[] myParams = null;
            Method[] myMethods = myClass.getMethods();
            this._myTypetag = "";
            for (int i = 0; i < myMethods.length; ++i) {
                if (!myMethods[i].getName().equals(this._myMethodName)) continue;
                myParams = myMethods[i].getParameterTypes();
                for (int j = 0; j < myParams.length; ++j) {
                    this._myTypetag = this._myTypetag + this.checkType(myParams[j].getName());
                }
                break;
            }
            if (myParams != null) {
                this.makeMethod(theObject.getClass(), myParams);
            } else {
                Logger.printWarning("OscPlug.plug()", "no arguments found for method " + this._myMethodName);
            }
        }
    }

    public void plug(Object theObject, String theMethodName, String theAddrPattern, String theTypetag) {
        this._myObject = theObject;
        this._myMethodName = theMethodName;
        this._myAddrPattern = theAddrPattern;
        this._myTypetag = theTypetag;
        this._myChecker = 0;
        if (this._myMethodName != null && this._myMethodName.length() > 0) {
            int tLen = this._myTypetag.length();
            Class<?>[] myParams = tLen > 0 ? this.getArgs(this._myTypetag) : null;
            if (this._isValid) {
                this.makeMethod(theObject.getClass(), myParams);
            }
        }
    }

    public Object getObject() {
        return this._myObject;
    }

    private void makeMethod(Class<?> theObjectsClass, Class<?>[] theClass) {
        try {
            this.method = theObjectsClass.getDeclaredMethod(this._myMethodName, theClass);
            this._myPattern = this._myAddrPattern + this._myTypetag;
            this.method.setAccessible(true);
            Logger.printProcess("OscPlug", "plugging " + theObjectsClass + " | " + "addrPattern:" + this._myAddrPattern + " typetag:" + this._myTypetag + " method:" + this._myMethodName);
        }
        catch (Exception e) {
            Class<?> theObjecsSuperClass = theObjectsClass.getSuperclass();
            if (theObjecsSuperClass.equals(Object.class)) {
                if (!theObjectsClass.getName().equals("java.awt.Component")) {
                    Logger.printError("OscPlug", "method " + theObjectsClass.getName() + " does not exist in your code.");
                }
            }
            this.makeMethod(theObjecsSuperClass, theClass);
        }
    }

    public boolean checkMethod(OscMessage theOscMessage, boolean isArray) {
        String myTypetag = isArray ? "" + theOscMessage.typetag().charAt(0) : theOscMessage.typetag();
        switch (this._myChecker) {
            case 0: {
                String thePattern = theOscMessage.addrPattern() + myTypetag;
                return thePattern.equals(this._myPattern);
            }
            case 1: {
                return theOscMessage.addrPattern().equals(this._myAddrPattern);
            }
            case 2: {
                return myTypetag.equals(this._myTypetag);
            }
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    public String checkType(String theName) {
        if (theName.equals("int")) {
            return "i";
        }
        if (theName.equals("float")) {
            return "f";
        }
        if (theName.equals("java.lang.String")) {
            return "s";
        }
        if (theName.equals("[Ljava.lang.String;")) {
            this.isArray = true;
            return "s";
        }
        if (theName.equals("char")) {
            return "c";
        }
        if (theName.equals("[B")) {
            return "b";
        }
        if (theName.equals("[F")) {
            this.isArray = true;
            return "f";
        }
        if (theName.equals("[I")) {
            this.isArray = true;
            return "i";
        }
        if (theName.equals("double")) {
            return "d";
        }
        if (theName.equals("boolean")) {
            return "T";
        }
        if (theName.equals("long")) {
            return "h";
        }
        return "";
    }

    private Class<?>[] getArgs(String theArgs) {
        char[] tChar = theArgs.toCharArray();
        int tLen = theArgs.length();
        Class[] tClass = new Class[tLen];
        block12: for (int i = 0; i < tLen; ++i) {
            switch (tChar[i]) {
                case 'i': {
                    tClass[i] = this.isArray ? int[].class : Integer.TYPE;
                    continue block12;
                }
                case 'S': 
                case 's': {
                    tClass[i] = this.isArray ? String[].class : String.class;
                    continue block12;
                }
                case 'f': {
                    tClass[i] = this.isArray ? float[].class : Float.TYPE;
                    continue block12;
                }
                case 'd': {
                    tClass[i] = Double.TYPE;
                    continue block12;
                }
                case 'c': {
                    tClass[i] = Character.TYPE;
                    continue block12;
                }
                case 'h': 
                case 'l': {
                    tClass[i] = Long.TYPE;
                    continue block12;
                }
                case 'T': {
                    tClass[i] = Boolean.TYPE;
                    continue block12;
                }
                case 'F': {
                    tClass[i] = Boolean.TYPE;
                    continue block12;
                }
                case 'b': {
                    tClass[i] = byte[].class;
                    continue block12;
                }
                case 'o': {
                    this._myChecker = 1;
                    tClass = new Class[]{Object[].class};
                    continue block12;
                }
                default: {
                    this._isValid = false;
                }
            }
        }
        if (!this._isValid) {
            tClass = null;
            System.out.println("ERROR could't plug method " + this._myMethodName);
        }
        return tClass;
    }
}

