/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.util.Vector;
import netP5.Logger;
import netP5.NetAddress;
import oscP5.OscEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OscProperties {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final int UDP = 0;
    public static final int MULTICAST = 1;
    public static final int TCP = 2;
    protected static final String[] _myProtocols = new String[]{"udp", "tcp", "multicast"};
    protected boolean isLocked = false;
    protected final Vector<OscEventListener> listeners;
    private NetAddress _myRemoteAddress = new NetAddress("", 0);
    private int _myListeningPort = 0;
    private int _myDatagramSize = 1536;
    protected String _myDefaultEventMethodName = "oscEvent";
    private int _myNetworkProtocol = 0;
    private boolean _mySendStatus = false;
    private boolean _mySRSP = false;

    public OscProperties(OscEventListener theParent) {
        this();
        this.listeners.add(theParent);
    }

    public OscProperties() {
        this.listeners = new Vector();
    }

    public Vector<OscEventListener> listeners() {
        return this.listeners;
    }

    public boolean sendStatus() {
        return this._mySendStatus;
    }

    public void setRemoteAddress(String theHostAddress, int thePort) {
        this._myRemoteAddress = new NetAddress(theHostAddress, thePort);
        this._mySendStatus = this._myRemoteAddress.isvalid();
    }

    public void setRemoteAddress(NetAddress theNetAddress) {
        this._myRemoteAddress = theNetAddress;
        this._mySendStatus = this._myRemoteAddress.isvalid();
    }

    public void setListeningPort(int thePort) {
        this._myListeningPort = thePort;
    }

    public void setDatagramSize(int theSize) {
        if (!this.isLocked) {
            this._myDatagramSize = theSize;
        } else {
            Logger.printWarning("OscProperties.setDatagramSize", "datagram size can only be set before initializing oscP5\ncurrent datagram size is " + this._myDatagramSize);
        }
    }

    public void setEventMethod(String theEventMethod) {
        this._myDefaultEventMethodName = theEventMethod;
    }

    public void setNetworkProtocol(int theProtocol) {
        if (!this.isLocked) {
            if (theProtocol > 2) {
                Logger.printWarning("OscProperties.setNetworkProtocol", "not in the range of supported Network protocols. the network protocol defaults to UDP");
            } else {
                this._myNetworkProtocol = theProtocol;
            }
        } else {
            Logger.printWarning("OscProperties.setNetworkProtocol", "network protocol can only be set before initializing oscP5.");
        }
    }

    public void setSRSP(boolean theFlag) {
        this._mySRSP = theFlag;
    }

    public boolean srsp() {
        return this._mySRSP;
    }

    public int listeningPort() {
        return this._myListeningPort;
    }

    public NetAddress remoteAddress() {
        return this._myRemoteAddress;
    }

    public int datagramSize() {
        return this._myDatagramSize;
    }

    public String eventMethod() {
        return this._myDefaultEventMethodName;
    }

    public int networkProtocol() {
        return this._myNetworkProtocol;
    }

    public String toString() {
        String s = "\nnetwork protocol: " + _myProtocols[this._myNetworkProtocol] + "\n";
        s = s + "host: " + (this._myRemoteAddress.address() != null ? this._myRemoteAddress.address() : "host address not set.") + "\n";
        s = s + "sendToPort: " + this._myRemoteAddress.port() + "\n";
        s = s + "receiveAtPort: " + this.listeningPort() + "\n";
        s = s + "datagramSize: " + this._myDatagramSize + "\n";
        s = s + "event Method: " + this._myDefaultEventMethodName + "\n";
        s = s + "(S)end(R)eceive(S)ame(P)ort: " + this._mySRSP + "\n\n";
        return s;
    }
}

