(ns de.sveri.friendui-datomic.storage
  (:require [de.sveri.friendui-datomic.db :as db]
            [de.sveri.friendui.globals :as f-glob]))


(defrecord FrienduiStorage [db-conn db-val]
  f-glob/FrienduiStorage
  (account-activated? [this activationid])
  (activate-account [this activationid]
    (db/activate-account db-conn (db-val) activationid))
  (create-user [this email password role activationid]
    (db/create-new-user db-conn email password role activationid))
  (get-all-users [this]
    (db/get-all-users (db-val)))
  (get-user-for-activation-id [this id]
    (db/get-user-for-activation-id (db-val) id))
  (update-user [this username data-map]
    (db/update-user db-conn username data-map))
  (username-exists? [this username]
    (db/username-exists? (db-val) username))
  (get-loggedin-user-map [this]
    (db/get-loggedin-user-map (db-val)))
  (get-old-pw-hash [this]
    (db/get-old-pw-hash (db-val)))
  (change-password [this new-pw]
    (db/change-password db-conn new-pw)))



