/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import com.google.protobuf.ByteString;
import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import de.topobyte.osm4j.pbf.seq.BlockWriter;
import de.topobyte.osm4j.pbf.util.BlobHeader;
import de.topobyte.osm4j.pbf.util.BlockData;
import de.topobyte.osm4j.pbf.util.PbfUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class CopyGroupwise {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("usage: " + CopyGroupwise.class.getSimpleName() + " <input> <output>");
            System.exit(1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        FileOutputStream output = new FileOutputStream(args[1]);
        DataInputStream data = new DataInputStream(input);
        BlockWriter blockWriter = new BlockWriter((OutputStream)output);
        try {
            while (true) {
                BlobHeader header = PbfUtil.parseHeader((DataInput)data);
                Fileformat.Blob blob = PbfUtil.parseBlock((DataInput)data, (int)header.getDataLength());
                String type = header.getType();
                if (type.equals("OSMData")) {
                    BlockData blockData = PbfUtil.getBlockData((Fileformat.Blob)blob);
                    Osmformat.PrimitiveBlock primBlock = Osmformat.PrimitiveBlock.parseFrom((ByteString)blockData.getBlobData());
                    Osmformat.PrimitiveBlock.Builder builder = Osmformat.PrimitiveBlock.newBuilder();
                    for (int i = 0; i < primBlock.getPrimitivegroupCount(); ++i) {
                        Osmformat.PrimitiveGroup.Builder groupBuilder = Osmformat.PrimitiveGroup.newBuilder();
                        Osmformat.PrimitiveGroup group = primBlock.getPrimitivegroup(i);
                        List nodes = group.getNodesList();
                        Osmformat.DenseNodes dense = group.getDense();
                        List ways = group.getWaysList();
                        List relations = group.getRelationsList();
                        groupBuilder.addAllNodes((Iterable)nodes);
                        if (group.hasDense()) {
                            groupBuilder.setDense(dense);
                        }
                        groupBuilder.addAllWays((Iterable)ways);
                        groupBuilder.addAllRelations((Iterable)relations);
                        builder.addPrimitivegroup(groupBuilder.build());
                    }
                    builder.setGranularity(primBlock.getGranularity());
                    builder.setDateGranularity(primBlock.getDateGranularity());
                    builder.setStringtable(primBlock.getStringtable());
                    Osmformat.PrimitiveBlock block = builder.build();
                    ByteString message = block.toByteString();
                    blockWriter.write(header.getType(), null, blockData.getCompression(), message);
                    continue;
                }
                if (!type.equals("OSMHeader")) continue;
                blockWriter.write(header.getType(), null, blob);
            }
        }
        catch (EOFException eof) {
            ((OutputStream)output).close();
            return;
        }
    }
}

