/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import com.google.protobuf.ByteString;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.pbf.Compression;
import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import de.topobyte.osm4j.pbf.seq.BlockWriter;
import de.topobyte.osm4j.pbf.util.BlobHeader;
import de.topobyte.osm4j.pbf.util.BlockData;
import de.topobyte.osm4j.pbf.util.PbfMeta;
import de.topobyte.osm4j.pbf.util.PbfUtil;
import de.topobyte.osm4j.pbf.util.copy.EntityGroups;
import de.topobyte.utilities.apache.commons.cli.OptionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySplit {
    static final Logger logger = LoggerFactory.getLogger(EntitySplit.class);
    private static String HELP_MESSAGE = EntitySplit.class.getSimpleName() + " [options]";
    private static final String OPTION_INPUT = "input";
    private static final String OPTION_OUTPUT_NODES = "output_nodes";
    private static final String OPTION_OUTPUT_WAYS = "output_ways";
    private static final String OPTION_OUTPUT_RELATIONS = "output_relations";
    private final OutputStream outNodes;
    private final OutputStream outWays;
    private final OutputStream outRelations;
    private boolean copyNodes;
    private boolean copyWays;
    private boolean copyRelations;
    private DataInputStream input;
    private BlockWriter blockWriterNodes = null;
    private BlockWriter blockWriterWays = null;
    private BlockWriter blockWriterRelations = null;

    public static void main(String[] args) throws IOException {
        FileOutputStream fos;
        String path;
        Options options = new Options();
        OptionHelper.addL((Options)options, (String)OPTION_INPUT, (boolean)true, (boolean)false, (String)"input file");
        OptionHelper.addL((Options)options, (String)OPTION_OUTPUT_NODES, (boolean)true, (boolean)false, (String)"the file to write nodes to");
        OptionHelper.addL((Options)options, (String)OPTION_OUTPUT_WAYS, (boolean)true, (boolean)false, (String)"the file to write ways to");
        OptionHelper.addL((Options)options, (String)OPTION_OUTPUT_RELATIONS, (boolean)true, (boolean)false, (String)"the file to write relations to");
        CommandLine line = null;
        try {
            line = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("unable to parse command line: " + e.getMessage());
            new HelpFormatter().printHelp(HELP_MESSAGE, options);
            System.exit(1);
        }
        if (line == null) {
            return;
        }
        BufferedInputStream in = null;
        if (line.hasOption(OPTION_INPUT)) {
            String inputPath = line.getOptionValue(OPTION_INPUT);
            File file = new File(inputPath);
            FileInputStream fis = new FileInputStream(file);
            in = new BufferedInputStream(fis);
        } else {
            in = new BufferedInputStream(System.in);
        }
        BufferedOutputStream outNodes = null;
        BufferedOutputStream outWays = null;
        BufferedOutputStream outRelations = null;
        if (line.hasOption(OPTION_OUTPUT_NODES)) {
            path = line.getOptionValue(OPTION_OUTPUT_NODES);
            fos = new FileOutputStream(path);
            outNodes = new BufferedOutputStream(fos);
        }
        if (line.hasOption(OPTION_OUTPUT_WAYS)) {
            path = line.getOptionValue(OPTION_OUTPUT_WAYS);
            fos = new FileOutputStream(path);
            outWays = new BufferedOutputStream(fos);
        }
        if (line.hasOption(OPTION_OUTPUT_RELATIONS)) {
            path = line.getOptionValue(OPTION_OUTPUT_RELATIONS);
            fos = new FileOutputStream(path);
            outRelations = new BufferedOutputStream(fos);
        }
        if (outNodes == null && outWays == null && outRelations == null) {
            System.out.println("You should specify an output for at least one entity");
            System.exit(1);
        }
        EntitySplit task = new EntitySplit(in, outNodes, outWays, outRelations);
        task.execute();
    }

    public EntitySplit(InputStream in, OutputStream outNodes, OutputStream outWays, OutputStream outRelations) {
        this.outNodes = outNodes;
        this.outWays = outWays;
        this.outRelations = outRelations;
        this.input = new DataInputStream(in);
        this.copyNodes = outNodes != null;
        this.copyWays = outWays != null;
        boolean bl = this.copyRelations = outRelations != null;
        if (this.copyNodes) {
            this.blockWriterNodes = new BlockWriter(outNodes);
        }
        if (this.copyWays) {
            this.blockWriterWays = new BlockWriter(outWays);
        }
        if (this.copyRelations) {
            this.blockWriterRelations = new BlockWriter(outRelations);
        }
    }

    public void execute() throws IOException {
        try {
            while (true) {
                BlobHeader header = PbfUtil.parseHeader((DataInput)this.input);
                Fileformat.Blob blob = PbfUtil.parseBlock((DataInput)this.input, (int)header.getDataLength());
                String type = header.getType();
                if (type.equals("OSMData")) {
                    this.data(blob);
                    continue;
                }
                if (!type.equals("OSMHeader")) continue;
                if (this.copyNodes) {
                    this.blockWriterNodes.write(header.getType(), null, blob);
                }
                if (this.copyWays) {
                    this.blockWriterWays.write(header.getType(), null, blob);
                }
                if (!this.copyRelations) continue;
                this.blockWriterRelations.write(header.getType(), null, blob);
            }
        }
        catch (EOFException eof) {
            if (this.copyNodes) {
                this.outNodes.close();
            }
            if (this.copyWays) {
                this.outWays.close();
            }
            if (this.copyRelations) {
                this.outRelations.close();
            }
            return;
        }
    }

    private void data(Fileformat.Blob blob) throws IOException {
        BlockData blockData = PbfUtil.getBlockData((Fileformat.Blob)blob);
        Osmformat.PrimitiveBlock primBlock = Osmformat.PrimitiveBlock.parseFrom((ByteString)blockData.getBlobData());
        if (!PbfMeta.hasMixedContent((Osmformat.PrimitiveBlock)primBlock)) {
            EntityType type = (EntityType)PbfMeta.getContentTypes((Osmformat.PrimitiveBlock)primBlock).iterator().next();
            if (type == EntityType.Node && this.copyNodes) {
                this.blockWriterNodes.write("OSMData", null, blob);
            } else if (type == EntityType.Way && this.copyWays) {
                this.blockWriterWays.write("OSMData", null, blob);
            } else if (type == EntityType.Relation && this.copyRelations) {
                this.blockWriterRelations.write("OSMData", null, blob);
            }
        } else {
            EntityGroups groups = EntityGroups.splitEntities((Osmformat.PrimitiveBlock)primBlock);
            Compression compression = blockData.getCompression();
            if (this.copyNodes && groups.getNodeGroups().size() > 0) {
                this.copy(this.blockWriterNodes, groups.getNodeGroups(), primBlock, compression);
            }
            if (this.copyWays && groups.getWayGroups().size() > 0) {
                this.copy(this.blockWriterWays, groups.getWayGroups(), primBlock, compression);
            }
            if (this.copyRelations && groups.getRelationGroups().size() > 0) {
                this.copy(this.blockWriterRelations, groups.getRelationGroups(), primBlock, compression);
            }
        }
    }

    private void copy(BlockWriter blockWriter, List<Osmformat.PrimitiveGroup> gs, Osmformat.PrimitiveBlock primBlock, Compression compression) throws IOException {
        Osmformat.PrimitiveBlock.Builder builder = Osmformat.PrimitiveBlock.newBuilder();
        for (Osmformat.PrimitiveGroup group : gs) {
            builder.addPrimitivegroup(group);
        }
        this.copyExtraData(builder, primBlock);
        Osmformat.PrimitiveBlock block = builder.build();
        blockWriter.write("OSMData", null, compression, block.toByteString());
    }

    private void copyExtraData(Osmformat.PrimitiveBlock.Builder builder, Osmformat.PrimitiveBlock primBlock) {
        builder.setGranularity(primBlock.getGranularity());
        builder.setDateGranularity(primBlock.getDateGranularity());
        builder.setStringtable(primBlock.getStringtable());
    }
}

