/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import com.google.protobuf.ByteString;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.pbf.Compression;
import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import de.topobyte.osm4j.pbf.raf.FileStructure;
import de.topobyte.osm4j.pbf.raf.FileStructureAnalyzer;
import de.topobyte.osm4j.pbf.raf.Interval;
import de.topobyte.osm4j.pbf.raf.PbfFile;
import de.topobyte.osm4j.pbf.seq.BlockWriter;
import de.topobyte.osm4j.pbf.util.BlockData;
import de.topobyte.osm4j.pbf.util.PbfUtil;
import de.topobyte.osm4j.pbf.util.copy.EntityGroups;
import de.topobyte.utilities.apache.commons.cli.OptionHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySplitBlockwise {
    static final Logger logger = LoggerFactory.getLogger(EntitySplitBlockwise.class);
    private static String HELP_MESSAGE = EntitySplitBlockwise.class.getSimpleName() + " [options]";
    private static final String OPTION_INPUT = "input";
    private static final String OPTION_OUTPUT_NODES = "output_nodes";
    private static final String OPTION_OUTPUT_WAYS = "output_ways";
    private static final String OPTION_OUTPUT_RELATIONS = "output_relations";
    private final OutputStream outNodes;
    private final OutputStream outWays;
    private final OutputStream outRelations;
    private boolean copyNodes;
    private boolean copyWays;
    private boolean copyRelations;
    private PbfFile pbfFile;
    private BlockWriter blockWriterNodes = null;
    private BlockWriter blockWriterWays = null;
    private BlockWriter blockWriterRelations = null;

    public static void main(String[] args) throws IOException {
        FileOutputStream fos;
        String path;
        Options options = new Options();
        OptionHelper.addL((Options)options, (String)OPTION_INPUT, (boolean)true, (boolean)true, (String)"input file");
        OptionHelper.addL((Options)options, (String)OPTION_OUTPUT_NODES, (boolean)true, (boolean)false, (String)"the file to write nodes to");
        OptionHelper.addL((Options)options, (String)OPTION_OUTPUT_WAYS, (boolean)true, (boolean)false, (String)"the file to write ways to");
        OptionHelper.addL((Options)options, (String)OPTION_OUTPUT_RELATIONS, (boolean)true, (boolean)false, (String)"the file to write relations to");
        CommandLine line = null;
        try {
            line = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("unable to parse command line: " + e.getMessage());
            new HelpFormatter().printHelp(HELP_MESSAGE, options);
            System.exit(1);
        }
        if (line == null) {
            return;
        }
        String inputPath = line.getOptionValue(OPTION_INPUT);
        File file = new File(inputPath);
        PbfFile pbfFile = new PbfFile(file);
        BufferedOutputStream outNodes = null;
        BufferedOutputStream outWays = null;
        BufferedOutputStream outRelations = null;
        if (line.hasOption(OPTION_OUTPUT_NODES)) {
            path = line.getOptionValue(OPTION_OUTPUT_NODES);
            fos = new FileOutputStream(path);
            outNodes = new BufferedOutputStream(fos);
        }
        if (line.hasOption(OPTION_OUTPUT_WAYS)) {
            path = line.getOptionValue(OPTION_OUTPUT_WAYS);
            fos = new FileOutputStream(path);
            outWays = new BufferedOutputStream(fos);
        }
        if (line.hasOption(OPTION_OUTPUT_RELATIONS)) {
            path = line.getOptionValue(OPTION_OUTPUT_RELATIONS);
            fos = new FileOutputStream(path);
            outRelations = new BufferedOutputStream(fos);
        }
        if (outNodes == null && outWays == null && outRelations == null) {
            System.out.println("You should specify an output for at least one entity");
            System.exit(1);
        }
        EntitySplitBlockwise task = new EntitySplitBlockwise(pbfFile, outNodes, outWays, outRelations);
        task.execute();
    }

    public EntitySplitBlockwise(PbfFile pbfFile, OutputStream outNodes, OutputStream outWays, OutputStream outRelations) {
        this.pbfFile = pbfFile;
        this.outNodes = outNodes;
        this.outWays = outWays;
        this.outRelations = outRelations;
        this.copyNodes = outNodes != null;
        this.copyWays = outWays != null;
        boolean bl = this.copyRelations = outRelations != null;
        if (this.copyNodes) {
            this.blockWriterNodes = new BlockWriter(outNodes);
        }
        if (this.copyWays) {
            this.blockWriterWays = new BlockWriter(outWays);
        }
        if (this.copyRelations) {
            this.blockWriterRelations = new BlockWriter(outRelations);
        }
    }

    public void execute() throws IOException {
        FileStructure structure = FileStructureAnalyzer.analyze((PbfFile)this.pbfFile);
        Interval nodes = structure.getBlocksNodes();
        Interval ways = structure.getBlocksWays();
        Interval relations = structure.getBlocksRelations();
        this.print("nodes", nodes);
        this.print("ways", ways);
        this.print("relations", relations);
        boolean lastNodeBlockMixed = false;
        boolean lastWayBlockMixed = false;
        boolean firstWayBlockMixed = false;
        boolean firstRelationBlockMixed = false;
        if (nodes != null && ways != null) {
            lastNodeBlockMixed |= nodes.getEnd() == ways.getStart();
            firstWayBlockMixed |= nodes.getEnd() == ways.getStart();
        }
        if (nodes != null && relations != null) {
            lastNodeBlockMixed |= nodes.getEnd() == relations.getStart();
            firstRelationBlockMixed |= nodes.getEnd() == relations.getStart();
        }
        if (ways != null && relations != null) {
            lastWayBlockMixed |= ways.getEnd() == relations.getStart();
            firstRelationBlockMixed |= ways.getEnd() == relations.getStart();
        }
        System.out.println("Last node block mixed? " + lastNodeBlockMixed);
        System.out.println("First way block mixed? " + firstWayBlockMixed);
        System.out.println("Last way block mixed? " + lastWayBlockMixed);
        System.out.println("First relation block mixed? " + firstRelationBlockMixed);
        if (this.copyNodes) {
            this.writeHeader(this.blockWriterNodes);
            this.copyNodes(nodes, lastNodeBlockMixed);
            this.outNodes.close();
        }
        if (this.copyWays) {
            this.writeHeader(this.blockWriterWays);
            this.copyWays(ways, firstWayBlockMixed, lastWayBlockMixed);
            this.outWays.close();
        }
        if (this.copyRelations) {
            this.writeHeader(this.blockWriterRelations);
            this.copyRelations(relations, firstRelationBlockMixed);
            this.outRelations.close();
        }
    }

    private void print(String type, Interval blocks) {
        System.out.println(String.format("%s: %d - %d", type, blocks.getStart(), blocks.getEnd()));
    }

    private void writeHeader(BlockWriter blockWriter) throws IOException {
        if (!this.pbfFile.hasHeader()) {
            return;
        }
        Osmformat.HeaderBlock header = this.pbfFile.getHeaderBlock();
        ByteString headerData = header.toByteString();
        blockWriter.write("OSMHeader", null, Compression.DEFLATE, headerData);
    }

    private void copyNodes(Interval nodes, boolean lastNodeBlockDirty) throws IOException {
        int lastNodeOnlyBlock = nodes.getEnd();
        if (lastNodeBlockDirty) {
            --lastNodeOnlyBlock;
        }
        for (int i = nodes.getStart(); i <= lastNodeOnlyBlock; ++i) {
            Fileformat.Blob blob = this.pbfFile.getDataBlob(i);
            this.blockWriterNodes.write("OSMData", null, blob);
        }
        if (!lastNodeBlockDirty) {
            return;
        }
        this.copyPartial(nodes.getEnd(), EntityType.Node, this.blockWriterNodes);
    }

    private void copyWays(Interval ways, boolean firstWayBlockMixed, boolean lastWayBlockMixed) throws IOException {
        int firstWayOnlyBlock = ways.getStart();
        if (firstWayBlockMixed) {
            ++firstWayOnlyBlock;
        }
        int lastWayOnlyBlock = ways.getEnd();
        if (lastWayBlockMixed) {
            --lastWayOnlyBlock;
        }
        if (firstWayBlockMixed) {
            this.copyPartial(ways.getStart(), EntityType.Way, this.blockWriterWays);
        }
        for (int i = firstWayOnlyBlock; i <= lastWayOnlyBlock; ++i) {
            Fileformat.Blob blob = this.pbfFile.getDataBlob(i);
            this.blockWriterWays.write("OSMData", null, blob);
        }
        if (!lastWayBlockMixed) {
            return;
        }
        if (ways.getStart() == ways.getEnd()) {
            return;
        }
        this.copyPartial(ways.getEnd(), EntityType.Way, this.blockWriterWays);
    }

    private void copyRelations(Interval relations, boolean firstRelationBlockMixed) throws IOException {
        int firstRelationOnlyBlock = relations.getStart();
        if (firstRelationBlockMixed) {
            ++firstRelationOnlyBlock;
        }
        if (firstRelationBlockMixed) {
            this.copyPartial(relations.getStart(), EntityType.Relation, this.blockWriterRelations);
        }
        for (int i = firstRelationOnlyBlock; i <= relations.getEnd(); ++i) {
            Fileformat.Blob blob = this.pbfFile.getDataBlob(i);
            this.blockWriterRelations.write("OSMData", null, blob);
        }
    }

    private void copyPartial(int blockIndex, EntityType type, BlockWriter blockWriter) throws IOException {
        Fileformat.Blob blob = this.pbfFile.getDataBlob(blockIndex);
        BlockData blockData = PbfUtil.getBlockData((Fileformat.Blob)blob);
        Osmformat.PrimitiveBlock block = Osmformat.PrimitiveBlock.parseFrom((ByteString)blockData.getBlobData());
        EntityGroups groups = EntityGroups.splitEntities((Osmformat.PrimitiveBlock)block);
        this.copy(blockWriter, groups.getGroups(type), block, blockData.getCompression());
    }

    private void copy(BlockWriter blockWriter, List<Osmformat.PrimitiveGroup> gs, Osmformat.PrimitiveBlock primBlock, Compression compression) throws IOException {
        Osmformat.PrimitiveBlock.Builder builder = Osmformat.PrimitiveBlock.newBuilder();
        for (Osmformat.PrimitiveGroup group : gs) {
            builder.addPrimitivegroup(group);
        }
        this.copyExtraData(builder, primBlock);
        Osmformat.PrimitiveBlock block = builder.build();
        blockWriter.write("OSMData", null, compression, block.toByteString());
    }

    private void copyExtraData(Osmformat.PrimitiveBlock.Builder builder, Osmformat.PrimitiveBlock primBlock) {
        builder.setGranularity(primBlock.getGranularity());
        builder.setDateGranularity(primBlock.getDateGranularity());
        builder.setStringtable(primBlock.getStringtable());
    }
}

