/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.pbf.raf.FileStructure;
import de.topobyte.osm4j.pbf.raf.FileStructureAnalyzer;
import de.topobyte.osm4j.pbf.raf.Interval;
import de.topobyte.osm4j.pbf.raf.PbfFile;
import java.io.File;
import java.io.IOException;

public class FindEntityBlockIntervals {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("usage: " + FindEntityBlockIntervals.class.getSimpleName() + " <filename>");
            System.exit(1);
        }
        File file = new File(args[0]);
        PbfFile pbfFile = new PbfFile(file);
        pbfFile.buildBlockIndex();
        FileStructure fileStructure = FileStructureAnalyzer.analyze((PbfFile)pbfFile);
        for (EntityType type : EntityType.values()) {
            if (!fileStructure.hasType(type)) {
                System.out.println(type + ": none");
                continue;
            }
            Interval blocks = fileStructure.getBlocks(type);
            System.out.println(String.format(type + ": [%d, %d]", blocks.getStart(), blocks.getEnd()));
        }
    }
}

