/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.executables;

import de.topobyte.osm4j.pbf.Compression;
import de.topobyte.osm4j.pbf.protobuf.Fileformat;
import de.topobyte.osm4j.pbf.seq.BlockWriter;
import de.topobyte.osm4j.pbf.util.BlobHeader;
import de.topobyte.osm4j.pbf.util.BlockData;
import de.topobyte.osm4j.pbf.util.PbfUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Uncompress {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("usage: " + Uncompress.class.getSimpleName() + " <input> <output>");
            System.exit(1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        FileOutputStream output = new FileOutputStream(args[1]);
        DataInputStream data = new DataInputStream(input);
        BlockWriter blockWriter = new BlockWriter((OutputStream)output);
        try {
            while (true) {
                BlobHeader header = PbfUtil.parseHeader((DataInput)data);
                Fileformat.Blob blob = PbfUtil.parseBlock((DataInput)data, (int)header.getDataLength());
                BlockData blockData = PbfUtil.getBlockData((Fileformat.Blob)blob);
                blockWriter.write(header.getType(), null, Compression.NONE, blockData.getBlobData());
            }
        }
        catch (EOFException eof) {
            ((OutputStream)output).close();
            return;
        }
    }
}

