/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.pbf.util;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.pbf.protobuf.Osmformat;
import java.util.HashSet;
import java.util.Set;

public class PbfMeta {
    public static boolean hasMixedContent(Osmformat.PrimitiveBlock block) {
        int count = block.getPrimitivegroupCount();
        if (count <= 1) {
            return false;
        }
        Set<EntityType> types = PbfMeta.getContentTypes(block);
        return types.size() > 1;
    }

    public static Set<EntityType> getContentTypes(Osmformat.PrimitiveBlock block) {
        int count = block.getPrimitivegroupCount();
        HashSet<EntityType> types = new HashSet<EntityType>();
        for (int i = 0; i < count; ++i) {
            Osmformat.PrimitiveGroup group = block.getPrimitivegroup(i);
            EntityType type = PbfMeta.getEntityType(group);
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    public static EntityType getEntityType(Osmformat.PrimitiveGroup group) {
        if (group.hasDense() || group.getNodesCount() > 0) {
            return EntityType.Node;
        }
        if (group.getWaysCount() > 0) {
            return EntityType.Way;
        }
        if (group.getRelationsCount() > 0) {
            return EntityType.Relation;
        }
        return null;
    }
}

