(ns sock.server
  (:require
   [clojure.core.async :as async :refer [<! >! put! chan dropping-buffer go-loop]]
   [clojure.edn :refer [read-string]]
   [org.httpkit.server :refer [with-channel websocket?]]))


(defn ws-handler [connection-chan & {:keys [in out err]
                                     :or {in  (chan (dropping-buffer 1024))
                                          out (chan (dropping-buffer 1024))
                                          err (chan (dropping-buffer 1024))}}]
  (fn [request]
      (with-channel request channel
        (when (websocket? channel)
          (put! log {:event :open :request request})
          (on-close channel (fn [status]
                              (put! log {:event :close :origin :remote :status status})
                              (close! in)
                              (close! out)
                              (close! log)))
          (on-receive channel (fn [data]
                                (put! in (read-string data))))
          (go-loop []
                   (let [data (<! out)]
                     (if data
                       (do (send! channel (pr-str data))
                         (recur))
                       (do (put! log {:event :close :origin :local})
                         (close channel)))))
          (put! connection-chan {:in in :out out :log log})))))
