/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab;

import de.uni_koblenz.jgralab.EclipseAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.pcollections.ArrayPMap;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class JGraLab {
    private static EclipseAdapter eclipseAdapter;
    private static String version;
    private static String codename;
    private static final String[] versionInfo;
    private static final String[] copyrightInfo;
    private static HashMap<String, Logger> loggerMap;
    private static Logger rootLogger;

    private static void readVersionFromManifest() {
        codename = "unknown";
        version = "unknown";
        if (eclipseAdapter != null) {
            version = eclipseAdapter.getJGraLabVersion();
            codename = eclipseAdapter.getJGraLabCodename();
        } else {
            try {
                Enumeration<URL> enumeration = JGraLab.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                JGraLab.extractVersionInfo(enumeration);
                if (version.equals("unknown") || codename.equals("unknown")) {
                    enumeration = JGraLab.class.getClassLoader().getResources("MANIFEST.MF");
                    JGraLab.extractVersionInfo(enumeration);
                    if (version.equals("unknown") || codename.equals("unknown")) {
                        JGraLab.getRootLogger().warning("MANIFEST.MF not found.");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void extractVersionInfo(Enumeration<URL> enumeration) throws IOException {
        while (enumeration.hasMoreElements()) {
            String string;
            URL uRL = enumeration.nextElement();
            Manifest manifest = new Manifest(uRL.openStream());
            Map<String, Attributes> map = manifest.getEntries();
            Attributes attributes = map.get("de/uni_koblenz/jgralab/");
            if (attributes == null || !(string = attributes.getValue("Implementation-Title")).equals("JGraLab")) continue;
            String[] stringArray = attributes.getValue("Implementation-Version").split("@");
            version = stringArray[0];
            codename = stringArray[1];
        }
    }

    private static String getVersion() {
        if (version == null) {
            JGraLab.readVersionFromManifest();
        }
        return version;
    }

    private static String getCodename() {
        if (codename == null) {
            JGraLab.readVersionFromManifest();
        }
        return codename;
    }

    public static Level setLogLevel(Level level) {
        Level level2 = JGraLab.getRootLogger().getLevel();
        JGraLab.getRootLogger().setLevel(level);
        return level2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getRootLogger() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (rootLogger == null) {
                rootLogger = Logger.getLogger("");
                loggerMap.put("", rootLogger);
                rootLogger.setUseParentHandlers(false);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                consoleHandler.setFormatter(new Formatter(){

                    @Override
                    public String format(LogRecord logRecord) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(logRecord.getLevel()).append(" ").append(logRecord.getSourceClassName()).append(".").append(logRecord.getSourceMethodName()).append(": ").append(logRecord.getMessage()).append('\n');
                        return stringBuilder.toString();
                    }
                });
                JGraLab.removeHandlers(rootLogger);
                rootLogger.addHandler(consoleHandler);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return rootLogger;
        }
    }

    private static void removeHandlers(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    public static Logger getLogger(String string) {
        if (string.equals("")) {
            return JGraLab.getRootLogger();
        }
        Logger logger = loggerMap.get(string);
        if (logger != null) {
            return logger;
        }
        logger = Logger.getLogger(string, null);
        logger.setParent(JGraLab.getParentLogger(string));
        logger.setLevel(null);
        logger.setUseParentHandlers(true);
        loggerMap.put(string, logger);
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        return JGraLab.getLogger(clazz.getPackage().getName());
    }

    private static Logger getParentLogger(String string) {
        if (!string.contains(".")) {
            return JGraLab.getRootLogger();
        }
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        return JGraLab.getLogger(string2);
    }

    public static void main(String[] stringArray) {
        System.out.println(JGraLab.getInfo(false));
    }

    private static String addInfo(String string) {
        return string.replace("$ver", JGraLab.getVersion()).replace("$codename", JGraLab.getCodename());
    }

    public static String getVersionInfo(boolean bl) {
        return JGraLab.getInfoString(versionInfo, bl);
    }

    public static String getInfo(boolean bl) {
        String[] stringArray = new String[versionInfo.length + copyrightInfo.length];
        System.arraycopy(versionInfo, 0, stringArray, 0, versionInfo.length);
        System.arraycopy(copyrightInfo, 0, stringArray, versionInfo.length, copyrightInfo.length);
        return JGraLab.getInfoString(stringArray, bl);
    }

    private static String getInfoString(String[] stringArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (bl) {
                stringBuilder.append("// ");
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(JGraLab.addInfo(string));
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public static final <T> PVector<T> vector() {
        return ArrayPVector.empty();
    }

    public static final <T> PSet<T> set() {
        return ArrayPSet.empty();
    }

    public static final <K, V> PMap<K, V> map() {
        return ArrayPMap.empty();
    }

    public static void setEclipseAdapter(EclipseAdapter eclipseAdapter) {
        JGraLab.eclipseAdapter = eclipseAdapter;
    }

    public static EclipseAdapter getEclipseAdapter() {
        return eclipseAdapter;
    }

    static {
        versionInfo = new String[]{"JGraLab - The Java graph laboratory", "  Version : $ver", "  Codename: $codename"};
        copyrightInfo = new String[]{"Copyright (C) 2006-2013 Institute for Software Technology", "                        University of Koblenz-Landau, Germany", "                        ist@uni-koblenz.de", "", "For bug reports, documentation and further information, visit", "", "                        https://github.com/jgralab/jgralab", "", "This program is free software; you can redistribute it and/or modify it", "under the terms of the GNU General Public License as published by the", "Free Software Foundation; either version 3 of the License, or (at your", "option) any later version.", "", "This program is distributed in the hope that it will be useful, but", "WITHOUT ANY WARRANTY; without even the implied warranty of", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General", "Public License for more details.", "", "You should have received a copy of the GNU General Public License along", "with this program; if not, see <http://www.gnu.org/licenses>.", "", "Additional permission under GNU GPL version 3 section 7", "", "If you modify this Program, or any covered work, by linking or combining", "it with Eclipse (or a modified version of that program or an Eclipse", "plugin), containing parts covered by the terms of the Eclipse Public", "License (EPL), the licensors of this Program grant you additional", "permission to convey the resulting work.  Corresponding Source for a", "non-source form of such a combination shall include the source code for", "the parts of JGraLab used as well as that of the covered work.", "", "This software uses:", "", "Apache Commons CLI 1.2", "Copyright 2001-2009 The Apache Software Foundation"};
        loggerMap = new HashMap();
        rootLogger = JGraLab.getRootLogger();
    }
}

