/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.reachability;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.ArrayBinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.ArrayRelation;
import de.uni_koblenz.jgralab.algolib.functions.BinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.functions.Relation;
import de.uni_koblenz.jgralab.algolib.problems.ReachabilitySolver;
import de.uni_koblenz.jgralab.algolib.problems.SimplePathsSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class WarshallAlgorithm
extends StructureOrientedAlgorithm
implements ReachabilitySolver,
SimplePathsSolver {
    private IntFunction<Vertex> indexMapping;
    private Permutation<Vertex> vertexOrder;
    private int vertexCount;
    private boolean[][] reachable;
    private Edge[][] successor;

    public WarshallAlgorithm(Graph graph) {
        this(graph, null);
    }

    public WarshallAlgorithm(Graph graph, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public WarshallAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public WarshallAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public WarshallAlgorithm undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void reset() {
        super.reset();
        BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(this.graph, null).withNumber();
        breadthFirstSearch.setTraversalDirection(this.traversalDirection);
        try {
            ((SearchAlgorithm)breadthFirstSearch).execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        assert (breadthFirstSearch.getState() == AlgorithmStates.FINISHED);
        this.indexMapping = breadthFirstSearch.getNumber();
        this.vertexOrder = breadthFirstSearch.getVertexOrder();
        this.vertexCount = this.graph.getVCount();
        this.reachable = new boolean[this.vertexCount + 1][this.vertexCount + 1];
        this.successor = new Edge[this.vertexCount + 1][this.vertexCount + 1];
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.traversalDirection = EdgeDirection.OUT;
    }

    @Override
    public WarshallAlgorithm execute() throws AlgorithmTerminatedException {
        int n;
        this.startRunning();
        int n2 = this.vertexCount + 1;
        for (int i = 1; i < n2; ++i) {
            for (int j = 1; j < n2; ++j) {
                this.successor[i][j] = null;
            }
            this.reachable[i][i] = true;
        }
        for (Edge edge : this.graph.edges()) {
            if (this.navigable != null && !this.navigable.get(edge)) continue;
            n = this.indexMapping.get(edge.getAlpha());
            int n3 = this.indexMapping.get(edge.getOmega());
            switch (this.traversalDirection) {
                case OUT: {
                    this.reachable[n][n3] = true;
                    this.successor[n][n3] = edge;
                    break;
                }
                case INOUT: {
                    this.reachable[n][n3] = true;
                    this.reachable[n3][n] = true;
                    this.successor[n][n3] = edge;
                    this.successor[n3][n] = edge.getReversedEdge();
                    break;
                }
                case IN: {
                    this.reachable[n3][n] = true;
                    this.successor[n3][n] = edge.getReversedEdge();
                }
            }
        }
        for (int i = 1; i <= this.vertexCount; ++i) {
            for (int j = 1; j <= this.vertexCount; ++j) {
                for (n = 1; n <= this.vertexCount; ++n) {
                    if (!this.reachable[j][i] || !this.reachable[i][n] || this.reachable[j][n]) continue;
                    this.cancelIfInterrupted();
                    this.reachable[j][n] = true;
                    this.successor[j][n] = this.successor[j][i];
                }
            }
        }
        this.done();
        return this;
    }

    @Override
    public Relation<Vertex, Vertex> getReachable() {
        this.checkStateForResult();
        return new ArrayRelation<Vertex>(this.reachable, this.indexMapping);
    }

    @Override
    public BinaryFunction<Vertex, Vertex, Edge> getSuccessor() {
        return new ArrayBinaryFunction<Vertex, Edge>(this.successor, this.indexMapping);
    }

    public Permutation<Vertex> getVertexOrder() {
        return this.vertexOrder;
    }

    public IntFunction<Vertex> getIndexMapping() {
        return this.indexMapping;
    }

    public boolean[][] getInternalReachable() {
        return this.reachable;
    }

    public Edge[][] getInternalSuccessor() {
        return this.successor;
    }
}

