/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class ArrayGraphMarker<T extends GraphElement<?, ?>, O>
extends AbstractGraphMarker<T>
implements Function<T, O> {
    protected Object[] temporaryAttributes;
    protected int marked;
    protected long version;

    protected ArrayGraphMarker(Graph graph, int n) {
        super(graph);
        this.temporaryAttributes = new Object[n];
        this.marked = 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = null;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.isValid());
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.temporaryAttributes[t.getId()] != null;
    }

    public O getMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.isValid());
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        Object object = this.temporaryAttributes[t.getId()];
        return (O)object;
    }

    public O mark(T t, O o) {
        assert (t.getGraph() == this.graph);
        assert (t.isValid());
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        Object object = this.temporaryAttributes[t.getId()];
        this.temporaryAttributes[t.getId()] = o;
        ++this.marked;
        ++this.version;
        return (O)object;
    }

    @Override
    public int size() {
        return this.marked;
    }

    @Override
    public boolean removeMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.isValid());
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (this.temporaryAttributes[t.getId()] == null) {
            return false;
        }
        this.temporaryAttributes[t.getId()] = null;
        --this.marked;
        ++this.version;
        return true;
    }

    protected void expand(int n) {
        assert (n > this.temporaryAttributes.length);
        Object[] objectArray = new Object[n];
        System.arraycopy(this.temporaryAttributes, 0, objectArray, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = objectArray;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    @Override
    public O get(T t) {
        return this.getMark(t);
    }

    @Override
    public boolean isDefined(T t) {
        return this.isMarked(t);
    }

    @Override
    public void set(T t, O o) {
        this.mark(t, o);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator iterator = this.getMarkedElements().iterator();
        if (iterator.hasNext()) {
            GraphElement graphElement = (GraphElement)iterator.next();
            stringBuilder.append(graphElement);
            stringBuilder.append(" -> ");
            stringBuilder.append(this.get((T)graphElement));
            while (iterator.hasNext()) {
                stringBuilder.append(",\n");
                graphElement = (GraphElement)iterator.next();
                stringBuilder.append(graphElement);
                stringBuilder.append(" -> ");
                stringBuilder.append(this.get((T)graphElement));
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<FunctionEntry<T, O>> iterator() {
        final Iterator iterator = this.getMarkedElements().iterator();
        return new Iterator<FunctionEntry<T, O>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FunctionEntry<T, O> next() {
                GraphElement graphElement = (GraphElement)iterator.next();
                return new FunctionEntry(graphElement, ArrayGraphMarker.this.get(graphElement));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

