/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.MapGraphMarker;
import java.util.Iterator;

public class DirectedGraphMarker<O>
extends MapGraphMarker<AttributedElement<?, ?>, O> {
    public DirectedGraphMarker(Graph graph) {
        super(graph);
    }

    @Override
    public O getMark(AttributedElement<?, ?> attributedElement) {
        if (attributedElement == null) {
            return null;
        }
        assert (attributedElement instanceof GraphElement && ((GraphElement)attributedElement).getGraph() == this.graph || attributedElement == this.graph);
        return (O)this.tempAttributeMap.get(attributedElement);
    }

    @Override
    public O mark(AttributedElement<?, ?> attributedElement, O o) {
        assert (attributedElement instanceof GraphElement && ((GraphElement)attributedElement).getGraph() == this.graph || attributedElement == this.graph);
        return this.tempAttributeMap.put(attributedElement, o);
    }

    @Override
    public void edgeDeleted(Edge edge) {
        this.tempAttributeMap.remove(edge);
        this.tempAttributeMap.remove(edge.getReversedEdge());
    }

    @Override
    public boolean isMarked(AttributedElement<?, ?> attributedElement) {
        assert (attributedElement instanceof GraphElement && ((GraphElement)attributedElement).getGraph() == this.graph || attributedElement == this.graph);
        return this.tempAttributeMap.containsKey(attributedElement);
    }

    @Override
    public boolean removeMark(AttributedElement<?, ?> attributedElement) {
        assert (attributedElement instanceof GraphElement && ((GraphElement)attributedElement).getGraph() == this.graph || attributedElement == this.graph);
        return this.tempAttributeMap.remove(attributedElement) != null;
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
        this.tempAttributeMap.remove(vertex);
    }

    @Override
    public Iterable<AttributedElement<?, ?>> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<FunctionEntry<AttributedElement<?, ?>, O>> iterator() {
        final Iterator iterator = this.getMarkedElements().iterator();
        return new Iterator<FunctionEntry<AttributedElement<?, ?>, O>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FunctionEntry<AttributedElement<?, ?>, O> next() {
                AttributedElement attributedElement = (AttributedElement)iterator.next();
                return new FunctionEntry(attributedElement, DirectedGraphMarker.this.get(attributedElement));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

