/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.IntFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class IntegerGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements IntFunction<T> {
    private static final int DEFAULT_UNMARKED_VALUE = Integer.MIN_VALUE;
    protected int[] temporaryAttributes;
    protected int marked;
    protected int unmarkedValue = Integer.MIN_VALUE;
    protected long version;

    protected IntegerGraphMarker(Graph graph, int n) {
        super(graph);
        this.temporaryAttributes = this.createNewArray(n);
        this.marked = 0;
    }

    private int[] createNewArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.unmarkedValue;
        }
        return nArray;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = this.unmarkedValue;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.temporaryAttributes[t.getId()] != this.unmarkedValue;
    }

    public int mark(T t, int n) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        int n2 = this.temporaryAttributes[t.getId()];
        this.temporaryAttributes[t.getId()] = n;
        ++this.marked;
        ++this.version;
        return n2;
    }

    public int getMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        int n = this.temporaryAttributes[t.getId()];
        return n;
    }

    @Override
    public boolean removeMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (this.temporaryAttributes[t.getId()] == this.unmarkedValue) {
            return false;
        }
        this.temporaryAttributes[t.getId()] = this.unmarkedValue;
        --this.marked;
        ++this.version;
        return true;
    }

    @Override
    public int size() {
        return this.marked;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    protected void expand(int n) {
        assert (n > this.temporaryAttributes.length);
        int[] nArray = this.createNewArray(n);
        System.arraycopy(this.temporaryAttributes, 0, nArray, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = nArray;
    }

    public int getUnmarkedValue() {
        return this.unmarkedValue;
    }

    public void setUnmarkedValue(int n) {
        if (n != this.unmarkedValue) {
            for (int i = 0; i < this.temporaryAttributes.length; ++i) {
                if (this.temporaryAttributes[i] == n) {
                    --this.marked;
                }
                if (this.temporaryAttributes[i] != this.unmarkedValue) continue;
                this.temporaryAttributes[i] = n;
            }
            this.unmarkedValue = n;
        }
    }

    @Override
    public int get(T t) {
        return this.getMark(t);
    }

    @Override
    public boolean isDefined(T t) {
        return this.isMarked(t);
    }

    @Override
    public void set(T t, int n) {
        this.mark(t, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator iterator = this.getMarkedElements().iterator();
        if (iterator.hasNext()) {
            GraphElement graphElement = (GraphElement)iterator.next();
            stringBuilder.append(graphElement);
            stringBuilder.append(" -> ");
            stringBuilder.append(this.get((T)graphElement));
            while (iterator.hasNext()) {
                stringBuilder.append(",\n");
                graphElement = (GraphElement)iterator.next();
                stringBuilder.append(graphElement);
                stringBuilder.append(" -> ");
                stringBuilder.append(this.get((T)graphElement));
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public Iterator<IntFunctionEntry<T>> iterator() {
        final Iterator iterator = this.getMarkedElements().iterator();
        return new Iterator<IntFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public IntFunctionEntry<T> next() {
                GraphElement graphElement = (GraphElement)iterator.next();
                return new IntFunctionEntry<GraphElement>(graphElement, IntegerGraphMarker.this.get(graphElement));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }
}

