/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.graphmarker.LongGraphMarker;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongVertexMarker
extends LongGraphMarker<Vertex> {
    public LongVertexMarker(Graph graph) {
        super(graph, ((InternalGraph)graph).getMaxVCount() + 1);
    }

    @Override
    public void edgeDeleted(Edge edge) {
    }

    @Override
    public void maxEdgeCountIncreased(int n) {
    }

    @Override
    public void maxVertexCountIncreased(int n) {
        if (++n > this.temporaryAttributes.length) {
            this.expand(n);
        }
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
        this.removeMark(vertex);
    }

    @Override
    public Iterable<Vertex> getMarkedElements() {
        return new Iterable<Vertex>(){

            @Override
            public Iterator<Vertex> iterator() {
                return new ArrayGraphMarkerIterator<Vertex>(LongVertexMarker.this.version){

                    @Override
                    public boolean hasNext() {
                        return this.index < LongVertexMarker.this.temporaryAttributes.length;
                    }

                    @Override
                    protected void moveIndex() {
                        int n = LongVertexMarker.this.temporaryAttributes.length;
                        while (this.index < n && LongVertexMarker.this.temporaryAttributes[this.index] == LongVertexMarker.this.unmarkedValue) {
                            ++this.index;
                        }
                    }

                    @Override
                    public Vertex next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                        }
                        if (this.version != LongVertexMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        Vertex vertex = LongVertexMarker.this.graph.getVertex(this.index++);
                        this.moveIndex();
                        return vertex;
                    }
                };
            }
        };
    }
}

