/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import java.util.HashMap;
import java.util.Iterator;

public abstract class MapGraphMarker<T extends AttributedElement<?, ?>, O>
extends AbstractGraphMarker<T>
implements Function<T, O> {
    protected HashMap<T, O> tempAttributeMap = new HashMap();

    protected MapGraphMarker(Graph graph) {
        super(graph);
    }

    public O getMark(T t) {
        if (t == null) {
            return null;
        }
        assert (t instanceof GraphElement && ((GraphElement)t).getGraph() == this.graph || t == this.graph);
        if (t instanceof ReversedEdgeBaseImpl) {
            t = this.getNormalEdge(t);
        }
        return this.tempAttributeMap.get(t);
    }

    public O mark(T t, O o) {
        assert (t instanceof GraphElement && ((GraphElement)t).getGraph() == this.graph || t == this.graph);
        if (t instanceof ReversedEdgeBaseImpl) {
            t = this.getNormalEdge(t);
        }
        return this.tempAttributeMap.put(t, o);
    }

    private T getNormalEdge(T object) {
        object = ((ReversedEdgeBaseImpl)object).getNormalEdge();
        return object;
    }

    @Override
    public int size() {
        return this.tempAttributeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tempAttributeMap.isEmpty();
    }

    @Override
    public void clear() {
        this.tempAttributeMap.clear();
    }

    @Override
    public Iterable<T> getMarkedElements() {
        return this.tempAttributeMap.keySet();
    }

    @Override
    public boolean isMarked(T t) {
        assert (t instanceof GraphElement && ((GraphElement)t).getGraph() == this.graph || t == this.graph);
        if (t instanceof ReversedEdgeBaseImpl) {
            t = this.getNormalEdge(t);
        }
        return this.tempAttributeMap.containsKey(t);
    }

    @Override
    public boolean removeMark(T t) {
        assert (t instanceof GraphElement && ((GraphElement)t).getGraph() == this.graph || t == this.graph);
        if (t instanceof ReversedEdgeBaseImpl) {
            t = this.getNormalEdge(t);
        }
        return this.tempAttributeMap.remove(t) != null;
    }

    @Override
    public void maxEdgeCountIncreased(int n) {
    }

    @Override
    public void maxVertexCountIncreased(int n) {
    }

    @Override
    public O get(T t) {
        return this.getMark(t);
    }

    @Override
    public boolean isDefined(T t) {
        return this.isMarked(t);
    }

    @Override
    public void set(T t, O o) {
        this.mark(t, o);
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<FunctionEntry<T, O>> iterator() {
        final Iterator<T> iterator = this.getMarkedElements().iterator();
        return new Iterator<FunctionEntry<T, O>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FunctionEntry<T, O> next() {
                AttributedElement attributedElement = (AttributedElement)iterator.next();
                return new FunctionEntry(attributedElement, MapGraphMarker.this.get(attributedElement));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

