/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.graphmarker.BitSetEdgeMarker;
import de.uni_koblenz.jgralab.graphmarker.BitSetVertexMarker;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SubGraphMarker
extends AbstractBooleanGraphMarker
implements TraversalContext {
    private final BitSetEdgeMarker edgeGraphMarker;
    private final BitSetVertexMarker vertexGraphMarker;
    private long version;

    public SubGraphMarker(Graph graph) {
        super(graph);
        this.edgeGraphMarker = new BitSetEdgeMarker(graph);
        this.vertexGraphMarker = new BitSetVertexMarker(graph);
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        ++this.version;
        this.edgeGraphMarker.clear();
        this.vertexGraphMarker.clear();
    }

    public int getECount() {
        return this.edgeGraphMarker.size();
    }

    public int getVCount() {
        return this.vertexGraphMarker.size();
    }

    @Override
    public boolean isEmpty() {
        return this.edgeGraphMarker.isEmpty() && this.vertexGraphMarker.isEmpty();
    }

    @Override
    public boolean isMarked(GraphElement<?, ?> graphElement) {
        return graphElement instanceof Edge ? this.edgeGraphMarker.isMarked((Edge)graphElement) : this.vertexGraphMarker.isMarked((Vertex)graphElement);
    }

    @Override
    public boolean isMarked(Vertex vertex) {
        return this.vertexGraphMarker.isMarked(vertex);
    }

    @Override
    public boolean isMarked(Edge edge) {
        return this.edgeGraphMarker.isMarked(edge);
    }

    @Override
    public int size() {
        return this.edgeGraphMarker.size() + this.vertexGraphMarker.size();
    }

    @Override
    public boolean removeMark(GraphElement<?, ?> graphElement) {
        return graphElement instanceof Edge ? this.removeMark((Edge)graphElement) : this.removeMark((Vertex)graphElement);
    }

    @Override
    public boolean removeMark(Edge edge) {
        if (this.edgeGraphMarker.removeMark(edge)) {
            ++this.version;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeMark(Vertex vertex) {
        if (this.vertexGraphMarker.removeMark(vertex)) {
            ++this.version;
            for (Edge edge : vertex.incidences()) {
                this.edgeGraphMarker.removeMark(edge);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mark(GraphElement<?, ?> graphElement) {
        return graphElement instanceof Edge ? this.mark((Edge)graphElement) : this.mark((Vertex)graphElement);
    }

    public boolean mark(Edge edge) {
        if (this.edgeGraphMarker.mark(edge)) {
            ++this.version;
            this.vertexGraphMarker.mark(edge.getAlpha());
            this.vertexGraphMarker.mark(edge.getOmega());
            return true;
        }
        return false;
    }

    public boolean mark(Vertex vertex) {
        if (this.vertexGraphMarker.mark(vertex)) {
            ++this.version;
            return true;
        }
        return false;
    }

    @Override
    public void edgeDeleted(Edge edge) {
        this.edgeGraphMarker.edgeDeleted(edge);
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
        this.vertexGraphMarker.vertexDeleted(vertex);
    }

    @Override
    public Iterable<GraphElement<?, ?>> getMarkedElements() {
        return new Iterable<GraphElement<?, ?>>(){

            @Override
            public Iterator<GraphElement<?, ?>> iterator() {
                return new ArrayGraphMarkerIterator<GraphElement<?, ?>>(SubGraphMarker.this.version){
                    Iterator<Vertex> vertexIterator;
                    Iterator<Edge> edgeIterator;
                    {
                        this.vertexIterator = SubGraphMarker.this.vertexGraphMarker.getMarkedElements().iterator();
                        this.edgeIterator = SubGraphMarker.this.edgeGraphMarker.getMarkedElements().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.vertexIterator.hasNext() || this.edgeIterator.hasNext();
                    }

                    @Override
                    protected void moveIndex() {
                    }

                    @Override
                    public GraphElement<?, ?> next() {
                        if (this.version != SubGraphMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        if (this.vertexIterator.hasNext()) {
                            return this.vertexIterator.next();
                        }
                        if (this.edgeIterator.hasNext()) {
                            return this.edgeIterator.next();
                        }
                        throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                    }
                };
            }
        };
    }

    @Override
    public boolean containsVertex(Vertex vertex) {
        return this.vertexGraphMarker.isMarked(vertex);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        boolean bl = this.edgeGraphMarker.isMarked(edge);
        return bl;
    }
}

