/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathSearchEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.funlib.graph.ReachableVertices;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import org.pcollections.PSet;

public class BackwardVertexSetEvaluator
extends PathSearchEvaluator<BackwardVertexSet> {
    private boolean initialized = false;
    private VertexEvaluator<? extends Expression> targetEval = null;

    public BackwardVertexSetEvaluator(BackwardVertexSet backwardVertexSet, GreqlQueryImpl greqlQueryImpl) {
        super(backwardVertexSet, greqlQueryImpl);
    }

    private final void initialize(InternalGreqlEvaluator internalGreqlEvaluator) {
        Expression expression = ((BackwardVertexSet)this.vertex).getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.targetEval = this.query.getVertexEvaluator(expression);
        this.initialized = true;
    }

    @Override
    public PSet<Vertex> evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        Vertex vertex;
        DFA dFA;
        if (!this.initialized) {
            this.initialize(internalGreqlEvaluator);
        }
        if ((dFA = (DFA)internalGreqlEvaluator.getLocalAutomaton(this.vertex)) == null) {
            vertex = (PathDescription)((BackwardVertexSet)this.vertex).getFirstIsPathOfIncidence(EdgeDirection.IN).getAlpha();
            PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)this.query.getVertexEvaluator(vertex);
            NFA nFA = NFA.revertNFA(pathDescriptionEvaluator.getNFA(internalGreqlEvaluator));
            dFA = new DFA(nFA);
            internalGreqlEvaluator.setLocalAutomaton(this.vertex, dFA);
        }
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        vertex = null;
        vertex = (Vertex)this.targetEval.getResult(internalGreqlEvaluator);
        return ReachableVertices.search(internalGreqlEvaluator, vertex, dFA);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        long l;
        BackwardVertexSet backwardVertexSet = (BackwardVertexSet)this.getVertex();
        Expression expression = backwardVertexSet.getFirstIsTargetExprOfIncidence().getAlpha();
        VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(expression);
        long l2 = vertexEvaluator.getCurrentSubtreeEvaluationCosts();
        PathDescription pathDescription = (PathDescription)backwardVertexSet.getFirstIsPathOfIncidence().getAlpha();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)this.query.getVertexEvaluator(pathDescription);
        long l3 = pathDescriptionEvaluator.getCurrentSubtreeEvaluationCosts();
        long l4 = l = Math.round((double)(l3 * 20L) * Math.sqrt(this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount()));
        long l5 = l4 * this.getVariableCombinations();
        long l6 = l2 + l3 + l5;
        return new VertexCosts(l4, l5, l6);
    }

    @Override
    public long calculateEstimatedCardinality() {
        return 5L;
    }
}

