/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ElementSetExpressionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.schema.EdgeSetExpression;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import org.pcollections.PSet;

public class EdgeSetExpressionEvaluator
extends ElementSetExpressionEvaluator<EdgeSetExpression> {
    public EdgeSetExpressionEvaluator(EdgeSetExpression edgeSetExpression, GreqlQueryImpl greqlQueryImpl) {
        super(edgeSetExpression, greqlQueryImpl);
    }

    @Override
    public PSet<Edge> evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        TypeCollection typeCollection = this.getTypeCollection(internalGreqlEvaluator);
        PSet<Edge> pSet = JGraLab.set();
        for (Edge edge = internalGreqlEvaluator.getGraph().getFirstEdge(); edge != null; edge = edge.getNextEdge()) {
            EdgeClass edgeClass = edge.getAttributedElementClass();
            if (!typeCollection.acceptsType(edgeClass)) continue;
            pSet = pSet.plus(edge);
        }
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        return pSet;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        EdgeSetExpression edgeSetExpression = (EdgeSetExpression)this.getVertex();
        long l = 0L;
        for (IsTypeRestrOfExpression isTypeRestrOfExpression = edgeSetExpression.getFirstIsTypeRestrOfExpressionIncidence(); isTypeRestrOfExpression != null; isTypeRestrOfExpression = isTypeRestrOfExpression.getNextIsTypeRestrOfExpressionIncidence()) {
            TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)this.query.getVertexEvaluator(isTypeRestrOfExpression.getAlpha());
            l += typeIdEvaluator.getCurrentSubtreeEvaluationCosts();
        }
        long l2 = this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount();
        return new VertexCosts(l2, l2, l + l2);
    }

    @Override
    public long calculateEstimatedCardinality() {
        long l;
        if (this.typeCollection != null) {
            l = this.typeCollection.getEstimatedGraphElementCount(this.query.getOptimizer().getOptimizerInfo());
        } else {
            EdgeSetExpression edgeSetExpression = (EdgeSetExpression)this.getVertex();
            IsTypeRestrOfExpression isTypeRestrOfExpression = edgeSetExpression.getFirstIsTypeRestrOfExpressionIncidence();
            double d = 1.0;
            if (isTypeRestrOfExpression != null) {
                TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)this.query.getVertexEvaluator(isTypeRestrOfExpression.getAlpha());
                d = typeIdEvaluator.getEstimatedSelectivity();
            }
            l = Math.round((double)this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount() * d);
        }
        logger.fine("EdgeSet estimated cardinality " + this.typeCollection + ": " + l);
        return l;
    }
}

