/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.pcollections.PCollection;
import org.pcollections.PVector;

public class SortByColumn
extends Function {
    @Description(params={"column", "t"}, description="Sorts a table of tuples by one column.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Table<Tuple> evaluate(Integer n, Table<Tuple> table) {
        return this.evaluate(JGraLab.vector().plus(n), table);
    }

    @Description(params={"columns", "t"}, description="Sorts a table of tuples by many columns.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Table<Tuple> evaluate(PVector<Integer> pVector, Table<Tuple> table) {
        Table table2 = Table.empty();
        return table2.withTitles(table.getTitles()).plusAll(this.evaluate(pVector, table.toPVector()));
    }

    @Description(params={"column", "l"}, description="Sorts a collection of tuples by one column.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public PVector<Tuple> evaluate(Integer n, PCollection<Tuple> pCollection) {
        return this.evaluate(JGraLab.vector().plus(n), pCollection);
    }

    @Description(params={"columns", "l"}, description="Sorts a collection of tuples by many columns.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public PVector<Tuple> evaluate(PVector<Integer> pVector, PCollection<Tuple> pCollection) {
        if (pVector.isEmpty()) {
            throw new IllegalArgumentException("Parameter columns must contain at least one column number.");
        }
        if (pCollection.isEmpty()) {
            return JGraLab.vector();
        }
        Tuple[] tupleArray = new Tuple[pCollection.size()];
        pCollection.toArray(tupleArray);
        Arrays.sort(tupleArray, new TupleComparator(pVector));
        PVector<Tuple> pVector2 = JGraLab.vector();
        for (Tuple tuple : tupleArray) {
            pVector2 = pVector2.plus(tuple);
        }
        return pVector2;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        long l = arrayList.get(0);
        return (long)((double)(2L * l) * Math.log(l));
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return n;
    }

    private static class TupleComparator
    implements Comparator<Tuple> {
        PVector<Integer> cols;

        TupleComparator(PVector<Integer> pVector) {
            this.cols = pVector;
        }

        @Override
        public int compare(Tuple tuple, Tuple tuple2) {
            int n = this.cols.size();
            int n2 = 0;
            for (int i = 0; i < n && n2 == 0; ++i) {
                int n3 = (Integer)this.cols.get(i);
                Comparable comparable = (Comparable)tuple.get(n3);
                Comparable comparable2 = (Comparable)tuple2.get(n3);
                n2 = comparable.compareTo(comparable2);
            }
            return n2;
        }
    }
}

