/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import org.pcollections.ArrayPMap;
import org.pcollections.ArrayPSet;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class Union
extends Function {
    @Description(params={"a", "b"}, description="Computes the union of the given two sets.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> pSet, PSet<T> pSet2) {
        if (pSet2.isEmpty()) {
            if (pSet instanceof ArrayPSet) {
                return pSet;
            }
            return JGraLab.set();
        }
        if (pSet instanceof ArrayPSet) {
            return ((ArrayPSet)pSet).plusAll(pSet2);
        }
        return JGraLab.set().plusAll(pSet).plusAll(pSet2);
    }

    @Description(params={"a", "b"}, description="Computes the union of the given maps.\nIn case of common keys in maps, the entries of the second one override the first one's entries.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <K, V> PMap<K, V> evaluate(PMap<K, V> pMap, PMap<K, V> pMap2) {
        if (pMap2.isEmpty()) {
            if (pMap instanceof ArrayPMap) {
                return pMap;
            }
            return JGraLab.map();
        }
        if (pMap instanceof ArrayPMap) {
            return ((ArrayPMap)pMap).plusAll(pMap2);
        }
        return JGraLab.map().plusAll(pMap).plusAll(pMap2);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return arrayList.get(0) + arrayList.get(1);
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return n;
    }
}

