/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import org.pcollections.PCollection;

@NeedsGraphArgument
public class ElementSetSubgraph
extends Function {
    @Description(params={"g", "vset", "eset"}, description="Returns the subgraph consisting of all vertices in vset and all edges in eset that connect vertices in vset.", categories={Function.Category.GRAPH})
    public ElementSetSubgraph() {
        super(7L, 1L, 1.0);
    }

    public SubGraphMarker evaluate(Graph graph, PCollection<Vertex> pCollection, PCollection<Edge> pCollection2) {
        SubGraphMarker subGraphMarker = new SubGraphMarker(graph);
        for (Vertex graphElement : pCollection) {
            subGraphMarker.mark(graphElement);
        }
        for (Edge edge : pCollection2) {
            if (!subGraphMarker.isMarked(edge.getAlpha()) || !subGraphMarker.isMarked(edge.getOmega())) continue;
            subGraphMarker.mark(edge);
        }
        return subGraphMarker;
    }
}

