/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.Attribute;
import java.util.HashMap;
import java.util.logging.Logger;

public class CommonSubgraphOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(CommonSubgraphOptimizer.class);
    private boolean anOptimizationWasDone = false;
    private final HashMap<String, GreqlVertex> subgraphMap = new HashMap();
    private final HashMap<GreqlVertex, String> reverseSubgraphMap = new HashMap();

    public CommonSubgraphOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof CommonSubgraphOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        this.anOptimizationWasDone = false;
        this.computeHashAndProcess(greqlQuery.getQueryGraph().getFirstGreqlExpression());
        return this.anOptimizationWasDone;
    }

    /*
     * WARNING - void declaration
     */
    private String computeHashAndProcess(GreqlVertex greqlVertex) {
        void var4_7;
        if (this.reverseSubgraphMap.containsKey(greqlVertex)) {
            return "{V" + greqlVertex.getId() + "}";
        }
        if (greqlVertex instanceof Variable) {
            return "{V" + greqlVertex.getId() + "}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{V");
        stringBuilder.append(":");
        stringBuilder.append(greqlVertex.getAttributedElementClass().getQualifiedName());
        stringBuilder.append(this.computeAttributeHash(greqlVertex));
        for (Edge graphElement2 : greqlVertex.incidences(EdgeDirection.IN)) {
            stringBuilder.append("{E:");
            stringBuilder.append(graphElement2.getAttributedElementClass().getQualifiedName());
            stringBuilder.append("}");
            stringBuilder.append(this.computeHashAndProcess((GreqlVertex)graphElement2.getThat()));
        }
        stringBuilder.append("}");
        String string = stringBuilder.toString();
        GreqlVertex greqlVertex2 = greqlVertex;
        if (this.subgraphMap.containsKey(string)) {
            GreqlVertex greqlVertex3 = this.subgraphMap.get(string);
            if (greqlVertex2.getId() > greqlVertex3.getId()) {
                GreqlVertex greqlVertex4 = greqlVertex2;
                GreqlVertex greqlVertex5 = greqlVertex3;
                greqlVertex3 = greqlVertex4;
                this.reverseSubgraphMap.remove(greqlVertex3);
            }
            this.mergeVertices((GreqlVertex)var4_7, greqlVertex3);
        }
        this.subgraphMap.put(string, (GreqlVertex)var4_7);
        this.reverseSubgraphMap.put((GreqlVertex)var4_7, string);
        return "{V" + var4_7.getId() + "}";
    }

    private String computeAttributeHash(GreqlVertex greqlVertex) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Attribute attribute : greqlVertex.getAttributedElementClass().getAttributeList()) {
            stringBuilder.append(attribute.getName());
            stringBuilder.append("=");
            Object t = greqlVertex.getAttribute(attribute.getName());
            if (t != null) {
                stringBuilder.append(t);
            }
            stringBuilder.append(";");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void mergeVertices(GreqlVertex greqlVertex, GreqlVertex greqlVertex2) {
        if (!(greqlVertex instanceof PathDescription)) {
            this.anOptimizationWasDone = true;
            logger.finer(this.optimizerHeaderString() + "Merging " + greqlVertex + " and " + greqlVertex2 + ".");
            this.mergeSourcePositionsBelow(greqlVertex, greqlVertex2);
            while (greqlVertex2.getFirstIncidence(EdgeDirection.OUT) != null) {
                greqlVertex2.getFirstIncidence(EdgeDirection.OUT).setAlpha(greqlVertex);
            }
            greqlVertex2.delete();
        }
    }

    private void mergeSourcePositionsBelow(GreqlVertex greqlVertex, GreqlVertex greqlVertex2) {
        GreqlAggregation greqlAggregation = greqlVertex.getFirstGreqlAggregationIncidence(EdgeDirection.IN);
        for (GreqlAggregation greqlAggregation2 = greqlVertex2.getFirstGreqlAggregationIncidence(EdgeDirection.IN); greqlAggregation != null && greqlAggregation2 != null; greqlAggregation = greqlAggregation.getNextGreqlAggregationIncidence(EdgeDirection.IN), greqlAggregation2 = greqlAggregation2.getNextGreqlAggregationIncidence(EdgeDirection.IN)) {
            OptimizerUtility.mergeSourcePositions(greqlAggregation2, greqlAggregation);
            this.mergeSourcePositionsBelow(greqlAggregation.getAlpha(), greqlAggregation2.getAlpha());
        }
    }
}

