/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MergeConstraintsOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(MergeConstraintsOptimizer.class);

    MergeConstraintsOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof MergeConstraintsOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        GreqlGraph greqlGraph = greqlQuery.getQueryGraph();
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (Declaration object : greqlGraph.getDeclarationVertices()) {
            arrayList.add(object);
        }
        boolean bl = false;
        for (Declaration declaration : arrayList) {
            ArrayList<IsConstraintOf> arrayList2 = new ArrayList<IsConstraintOf>();
            for (IsConstraintOf isConstraintOf : declaration.getIsConstraintOfIncidences(EdgeDirection.IN)) {
                arrayList2.add(isConstraintOf);
                IsConstraintOf isConstraintOf2 = isConstraintOf.getNextIsConstraintOfIncidence();
            }
            if (arrayList2.size() <= 1) continue;
            bl = true;
            Expression expression = this.createConjunction(arrayList2, greqlGraph);
            logger.finer(this.optimizerHeaderString() + "Merging constraints on edges " + arrayList2 + " into conjunction " + expression + ".");
            for (IsConstraintOf isConstraintOf : arrayList2) {
                isConstraintOf.delete();
            }
            greqlGraph.createIsConstraintOf(expression, declaration);
        }
        return bl;
    }

    public Expression createConjunction(List<IsConstraintOf> list, GreqlGraph greqlGraph) {
        if (list.size() == 1) {
            return list.get(0).getAlpha();
        }
        FunctionApplication functionApplication = greqlGraph.createFunctionApplication();
        FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("and", greqlGraph);
        greqlGraph.createIsFunctionIdOf(functionId, functionApplication);
        greqlGraph.createIsArgumentOf(list.get(0).getAlpha(), functionApplication);
        greqlGraph.createIsArgumentOf(this.createConjunction(list.subList(1, list.size()), greqlGraph), functionApplication);
        return functionApplication;
    }
}

