/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.HashMap;

public class OptimizerInfoGenerator {
    private Schema schema;
    private HashMap<GraphElementClass<?, ?>, Long> gecCount;
    private HashMap<GraphElementClass<?, ?>, Long> gecWithSubclassCount;
    private long totalVertexCount;
    private long totalEdgeCount;
    private int graphCount;

    public OptimizerInfoGenerator(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        this.schema = schema;
        this.gecCount = new HashMap();
        this.gecWithSubclassCount = new HashMap();
        for (GraphElementClass<?, ?> graphElementClass : schema.getGraphClass().getGraphElementClasses()) {
            this.gecCount.put(graphElementClass, 0L);
        }
    }

    public void scanGraph(Graph graph) {
        if (!this.schema.equals(graph.getSchema())) {
            throw new IllegalArgumentException("Graph has different schema, expected \"" + this.schema.getQualifiedName() + "\", found \"" + graph.getSchema().getQualifiedName() + "\"");
        }
        ++this.graphCount;
        this.totalVertexCount += (long)graph.getVCount();
        for (Vertex graphElement : graph.vertices()) {
            this.gecCount.put(graphElement.getAttributedElementClass(), this.gecCount.get(graphElement.getAttributedElementClass()) + 1L);
        }
        this.totalEdgeCount += (long)graph.getECount();
        for (Edge edge : graph.edges()) {
            this.gecCount.put(edge.getAttributedElementClass(), this.gecCount.get(edge.getAttributedElementClass()) + 1L);
        }
    }

    public void scanDirectory(String string, FilenameFilter filenameFilter, boolean bl) throws GraphIOException {
        File file = new File(string);
        System.out.println("Scanning directory \"" + file.getPath() + "\" ...");
        for (File file2 : file.listFiles()) {
            if (file2.isFile() && file2.canRead() && filenameFilter.accept(file, file2.getName())) {
                Graph graph = GraphIO.loadGraphFromFile(file2.getPath(), ImplementationType.GENERIC, (ProgressFunction)new ConsoleProgressFunction(file2.getName()));
                this.scanGraph(graph);
                continue;
            }
            if (!bl || !file2.isDirectory() || !file2.canRead()) continue;
            this.scanDirectory(file2.getPath(), filenameFilter, bl);
        }
    }

    public void scanDirectory(String string) throws GraphIOException {
        this.scanDirectory(string, GraphIO.TGFilenameFilter.instance(), false);
    }

    public void scanDirectory(String string, boolean bl) throws GraphIOException {
        this.scanDirectory(string, GraphIO.TGFilenameFilter.instance(), bl);
    }

    public void storeOptimizerInfo(String string) throws IOException {
        this.computeSubclassCounts();
        DefaultOptimizerInfo defaultOptimizerInfo = new DefaultOptimizerInfo(this.schema);
        defaultOptimizerInfo.setAvgVertexCount(this.totalVertexCount / (long)this.graphCount);
        defaultOptimizerInfo.setAvgEdgeCount(this.totalEdgeCount / (long)this.graphCount);
        for (GraphElementClass<?, ?> graphElementClass : this.schema.getGraphClass().getGraphElementClasses()) {
            defaultOptimizerInfo.setFrequencies(graphElementClass, this.getFrequency(graphElementClass, false), this.getFrequency(graphElementClass, true));
        }
        defaultOptimizerInfo.storePropertyFile(string);
    }

    public long getCount(GraphElementClass<?, ?> graphElementClass, boolean bl) {
        this.assertGraphScanned();
        if (bl) {
            return this.gecWithSubclassCount.get(graphElementClass);
        }
        return this.gecCount.get(graphElementClass);
    }

    public double getFrequency(GraphElementClass<?, ?> graphElementClass, boolean bl) {
        this.assertGraphScanned();
        return (double)this.getCount(graphElementClass, bl) / (double)(graphElementClass instanceof VertexClass ? this.totalVertexCount : this.totalEdgeCount);
    }

    public void printStatistics(PrintStream printStream) {
        this.computeSubclassCounts();
        printStream.println("Schema\t" + this.schema.getQualifiedName());
        printStream.println("Graphs\t" + this.graphCount);
        printStream.println("Vertices\t" + this.totalVertexCount);
        printStream.println("Edges\t" + this.totalEdgeCount);
        printStream.println("V/E\tGraphElementClass\tcount\twith subclasses\tfreq\twith subclasses");
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(16);
        for (GraphElementClass<?, ?> graphElementClass : this.schema.getGraphClass().getGraphElementClasses()) {
            printStream.println((graphElementClass instanceof VertexClass ? "V" : "E") + "\t" + graphElementClass.getQualifiedName() + "\t" + this.getCount(graphElementClass, false) + "\t" + this.getCount(graphElementClass, true) + "\t" + numberFormat.format(this.getFrequency(graphElementClass, false)) + "\t" + numberFormat.format(this.getFrequency(graphElementClass, true)));
        }
    }

    private void computeSubclassCounts() {
        this.assertGraphScanned();
        for (GraphElementClass<?, ?> graphElementClass : this.schema.getGraphClass().getGraphElementClasses()) {
            long l = this.gecCount.get(graphElementClass);
            for (GraphElementClass graphElementClass2 : graphElementClass.getAllSubClasses()) {
                l += this.gecCount.get(graphElementClass2).longValue();
            }
            this.gecWithSubclassCount.put(graphElementClass, l);
        }
    }

    private void assertGraphScanned() {
        if (this.graphCount == 0) {
            throw new IllegalStateException("No graph scanned yet");
        }
    }
}

