/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.EvaluatorUtilities;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.AbstractGraphElementCollectionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ElementSetExpressionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.ElementSetExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.HashMap;

public class TypeCollectionEvaluator
implements InternalGreqlEvaluator {
    private Schema schema;
    private HashMap<GreqlVertex, Object> results;
    private GreqlQueryImpl query;
    private GreqlExpression rootExpression;

    public TypeCollectionEvaluator(GreqlQueryImpl greqlQueryImpl) {
        this.query = greqlQueryImpl;
        this.rootExpression = greqlQueryImpl.getQueryGraph().getFirstGreqlExpression();
        this.results = new HashMap();
    }

    public void execute() {
        VertexEvaluator vertexEvaluator;
        OptimizerInfo optimizerInfo = this.query.getOptimizer().getOptimizerInfo();
        this.schema = optimizerInfo.getSchema();
        EvaluatorUtilities.checkImports(this.rootExpression, this.schema);
        GreqlGraph greqlGraph = this.query.getQueryGraph();
        for (TypeId expression : greqlGraph.getTypeIdVertices()) {
            vertexEvaluator = (TypeIdEvaluator)this.query.getVertexEvaluator(expression);
            ((TypeIdEvaluator)vertexEvaluator).evaluate(this);
        }
        for (ElementSetExpression elementSetExpression : greqlGraph.getElementSetExpressionVertices()) {
            vertexEvaluator = (ElementSetExpressionEvaluator)this.query.getVertexEvaluator(elementSetExpression);
            ((AbstractGraphElementCollectionEvaluator)vertexEvaluator).getTypeCollection(this);
        }
    }

    @Override
    public Object setVariable(String string, Object object) {
        return null;
    }

    @Override
    public Object getVariable(String string) {
        return null;
    }

    @Override
    public Object setLocalEvaluationResult(GreqlVertex greqlVertex, Object object) {
        return this.results.put(greqlVertex, object);
    }

    @Override
    public Object getLocalEvaluationResult(GreqlVertex greqlVertex) {
        return this.results.get(greqlVertex);
    }

    @Override
    public Object removeLocalEvaluationResult(GreqlVertex greqlVertex) {
        return this.results.remove(greqlVertex);
    }

    @Override
    public Graph getGraph() {
        return null;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public GraphElementClass<?, ?> getGraphElementClass(String string) {
        return EvaluatorUtilities.getGraphElementClass(this.rootExpression, this.schema, string);
    }

    @Override
    public void progress(long l) {
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public FiniteAutomaton setLocalAutomaton(GreqlVertex greqlVertex, FiniteAutomaton finiteAutomaton) {
        return null;
    }

    @Override
    public FiniteAutomaton getLocalAutomaton(GreqlVertex greqlVertex) {
        return null;
    }
}

