/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Equiv;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Not;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;

public class ConditionalExpressionUnit {
    private final GreqlQuery query;
    private final Expression condition;
    private final Formula trueFormula;
    private final Formula falseFormula;
    private double influenceCostRatio = -1.0;

    public ConditionalExpressionUnit(Expression expression, Formula formula) {
        this.query = formula.query;
        this.condition = expression;
        this.trueFormula = formula.calculateReplacementFormula(this.condition, new True(this.query)).simplify();
        this.falseFormula = formula.calculateReplacementFormula(this.condition, new False(this.query)).simplify();
    }

    private double calculateInfluenceCostRatio() {
        Formula formula = new Not(this.query, new Equiv(this.query, this.trueFormula, new Not(this.query, this.falseFormula)));
        formula = formula.simplify();
        double d = formula.getSelectivity();
        VertexEvaluator<Expression> vertexEvaluator = ((GreqlQueryImpl)this.query).getVertexEvaluator(this.condition);
        long l = vertexEvaluator.getInitialSubtreeEvaluationCosts();
        return d / (double)l;
    }

    ConditionalExpression toConditionalExpression() {
        return new ConditionalExpression(this.query, this.condition, this.trueFormula.optimize(), this.falseFormula.optimize());
    }

    public double getInfluenceCostRatio() {
        if (this.influenceCostRatio == -1.0) {
            this.influenceCostRatio = this.calculateInfluenceCostRatio();
        }
        return this.influenceCostRatio;
    }
}

