/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parallel;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.parallel.EvaluationEnvironment;
import de.uni_koblenz.jgralab.greql.parallel.ParallelGreqlEvaluatorCallable;
import de.uni_koblenz.jgralab.schema.exception.CycleException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;

public class ParallelGreqlEvaluator {
    private static Logger logger = JGraLab.getLogger(ParallelGreqlEvaluator.class);
    private DirectedAcyclicGraph<TaskHandle> dependencyGraph = new DirectedAcyclicGraph();
    private static int taskHandleSequence = 0;

    public EvaluationEnvironment evaluate() {
        return this.evaluate(null, new GreqlEnvironmentAdapter(), false);
    }

    public EvaluationEnvironment evaluate(boolean bl) {
        return this.evaluate(null, new GreqlEnvironmentAdapter(), bl);
    }

    public EvaluationEnvironment evaluate(Graph graph) {
        return this.evaluate(graph, new GreqlEnvironmentAdapter(), false, false);
    }

    public EvaluationEnvironment evaluate(Graph graph, boolean bl) {
        return this.evaluate(graph, new GreqlEnvironmentAdapter(), bl, false);
    }

    public EvaluationEnvironment evaluate(Graph graph, GreqlEnvironment greqlEnvironment) {
        return this.evaluate(graph, greqlEnvironment, false, false);
    }

    public EvaluationEnvironment evaluate(Graph graph, GreqlEnvironment greqlEnvironment, boolean bl) {
        return this.evaluate(graph, greqlEnvironment, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvaluationEnvironment evaluate(Graph graph, GreqlEnvironment greqlEnvironment, boolean bl, boolean bl2) {
        final EvaluationEnvironment evaluationEnvironment = new EvaluationEnvironment(bl2);
        evaluationEnvironment.startTime = System.nanoTime();
        evaluationEnvironment.datagraph = graph;
        evaluationEnvironment.greqlEnvironment = greqlEnvironment;
        SortedSet<TaskHandle> sortedSet = this.createEvaluationTasks(evaluationEnvironment);
        int n = bl2 ? 1 : Math.max(2, Runtime.getRuntime().availableProcessors() + 1);
        logger.fine("Create executor with " + n + " threads");
        evaluationEnvironment.executor = Executors.newFixedThreadPool(n);
        FutureTask<Object> futureTask = null;
        if (!bl2) {
            futureTask = new FutureTask<Object>((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    logger.finer("Run waiting for final tasks");
                    try {
                        for (TaskHandle taskHandle : ParallelGreqlEvaluator.this.dependencyGraph.getNodes()) {
                            try {
                                evaluationEnvironment.tasks.get(taskHandle).get();
                            }
                            catch (ExecutionException executionException) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
            }){

                @Override
                protected void done() {
                    super.done();
                    logger.finer("Done waiting for final tasks");
                }
            };
            logger.finer("Execute waiting for final tasks");
            evaluationEnvironment.executor.execute(futureTask);
        }
        for (TaskHandle taskHandle : sortedSet) {
            logger.fine("Execute initial " + taskHandle);
            evaluationEnvironment.executor.execute(evaluationEnvironment.tasks.get(taskHandle));
            if (!bl2) continue;
            try {
                evaluationEnvironment.tasks.get(taskHandle).get();
            }
            catch (Exception exception) {
                throw this.unwrapException(exception);
            }
        }
        if (!bl2) {
            try {
                futureTask.get();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        }
        evaluationEnvironment.executor.shutdown();
        EvaluationEnvironment evaluationEnvironment2 = evaluationEnvironment;
        synchronized (evaluationEnvironment2) {
            if (evaluationEnvironment.exception != null) {
                throw this.unwrapException(evaluationEnvironment.exception);
            }
        }
        if (bl) {
            this.adjustPriorities(evaluationEnvironment);
        }
        evaluationEnvironment.doneTime = System.nanoTime();
        return evaluationEnvironment;
    }

    private RuntimeException unwrapException(Exception exception) {
        Throwable throwable;
        for (throwable = exception; throwable != null && throwable instanceof ExecutionException; throwable = throwable.getCause()) {
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustPriorities(EvaluationEnvironment evaluationEnvironment) {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            logger.fine("Adjust priority values");
            for (TaskHandle taskHandle : this.dependencyGraph.getNodes()) {
                long l = taskHandle.priority;
                taskHandle.priority = evaluationEnvironment.getEvaluationTime(taskHandle);
                logger.finer(taskHandle.toString() + " - old prio " + l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedSet<TaskHandle> createEvaluationTasks(EvaluationEnvironment evaluationEnvironment) {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            this.calculateVariableDependencies();
            TreeSet<TaskHandle> treeSet = new TreeSet<TaskHandle>();
            for (TaskHandle taskHandle : this.dependencyGraph.getNodes()) {
                EvaluationTask evaluationTask = taskHandle.createFutureTask(evaluationEnvironment);
                evaluationEnvironment.tasks.put(taskHandle, evaluationTask);
                int n = this.dependencyGraph.getDirectPredecessors(taskHandle).size();
                evaluationEnvironment.inDegree.put(taskHandle, n);
                if (n != 0) continue;
                treeSet.add(taskHandle);
            }
            return treeSet;
        }
    }

    public EvaluationEnvironment evaluateSequentially(Graph graph, GreqlEnvironment greqlEnvironment, boolean bl) {
        return this.evaluate(graph, greqlEnvironment, bl, true);
    }

    public TaskHandle addTask(ParallelGreqlEvaluatorCallable parallelGreqlEvaluatorCallable) {
        return this.addTask(parallelGreqlEvaluatorCallable, 0L);
    }

    public TaskHandle addTask(ParallelGreqlEvaluatorCallable parallelGreqlEvaluatorCallable, long l) {
        return this.dependencyGraph.createNode(new TaskHandle(parallelGreqlEvaluatorCallable, l));
    }

    public TaskHandle addGreqlQuery(String string) {
        return this.addGreqlQuery(string, 0L);
    }

    public TaskHandle addGreqlQuery(String string, long l) {
        return this.addTask(GreqlQuery.createQuery(string), l);
    }

    public void defineDependency(TaskHandle taskHandle, TaskHandle taskHandle2) {
        try {
            this.dependencyGraph.createEdge(taskHandle2, taskHandle);
        }
        catch (CycleException cycleException) {
            throw new RuntimeException("Task dependencies are cyclic. Offending dependency: " + taskHandle + " ---dependsOn--> " + taskHandle2);
        }
        catch (SchemaException schemaException) {
            throw new RuntimeException("Task " + taskHandle2 + " depends on itself");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateVariableDependencies() {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            HashSet hashSet;
            Set<String> set;
            if (this.dependencyGraph.isFinished()) {
                return;
            }
            HashMap<String, HashSet> hashMap = new HashMap<String, HashSet>();
            for (TaskHandle taskHandle : this.dependencyGraph.getNodes()) {
                set = taskHandle.getStoredVariables();
                if (set == null) continue;
                for (String string : set) {
                    hashSet = (HashSet)hashMap.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                        hashMap.put(string, hashSet);
                    }
                    hashSet.add(taskHandle);
                }
            }
            for (TaskHandle taskHandle : this.dependencyGraph.getNodes()) {
                set = taskHandle.getUsedVariables();
                if (set == null) continue;
                for (String string : set) {
                    hashSet = (HashSet)hashMap.get(string);
                    if (hashSet == null) continue;
                    for (TaskHandle taskHandle2 : hashSet) {
                        this.defineDependency(taskHandle, taskHandle2);
                    }
                }
            }
            this.dependencyGraph.finish();
            logger.finer(this.dependencyGraph.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNext(EvaluationEnvironment evaluationEnvironment, TaskHandle taskHandle) {
        DirectedAcyclicGraph<TaskHandle> directedAcyclicGraph = this.dependencyGraph;
        synchronized (directedAcyclicGraph) {
            TreeSet<TaskHandle> treeSet = new TreeSet<TaskHandle>();
            for (TaskHandle taskHandle2 : this.dependencyGraph.getDirectSuccessors(taskHandle)) {
                int n = evaluationEnvironment.inDegree.get(taskHandle2) - 1;
                evaluationEnvironment.inDegree.put(taskHandle2, n);
                if (n != 0) continue;
                treeSet.add(taskHandle2);
            }
            for (TaskHandle taskHandle2 : treeSet) {
                logger.fine("Execute " + taskHandle2);
                evaluationEnvironment.executor.execute(evaluationEnvironment.tasks.get(taskHandle2));
                if (!evaluationEnvironment.sequentially) continue;
                try {
                    evaluationEnvironment.tasks.get(taskHandle2).get();
                }
                catch (Exception exception) {
                    throw this.unwrapException(exception);
                }
            }
        }
    }

    public class TaskHandle
    implements Comparable<TaskHandle> {
        private ParallelGreqlEvaluatorCallable callable;
        private long priority;
        private int seq;

        public String toString() {
            return "TaskHandle " + this.seq + " prio " + this.priority + " (use: " + this.getUsedVariables() + ", store:" + this.getStoredVariables() + ")";
        }

        public Set<String> getStoredVariables() {
            return this.callable.getStoredVariables();
        }

        public Set<String> getUsedVariables() {
            return this.callable.getUsedVariables();
        }

        @Override
        public int compareTo(TaskHandle taskHandle) {
            long l = taskHandle.priority - this.priority;
            if (l != 0L) {
                return l < 0L ? -1 : 1;
            }
            return this.seq - taskHandle.seq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TaskHandle(ParallelGreqlEvaluatorCallable parallelGreqlEvaluatorCallable, long l) {
            this.callable = parallelGreqlEvaluatorCallable;
            this.priority = l;
            Class<TaskHandle> clazz = TaskHandle.class;
            synchronized (TaskHandle.class) {
                this.seq = taskHandleSequence++;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        private EvaluationTask createFutureTask(final EvaluationEnvironment evaluationEnvironment) {
            return new EvaluationTask(evaluationEnvironment, this, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return TaskHandle.this.callable.call(evaluationEnvironment);
                }
            });
        }
    }

    class EvaluationTask
    extends FutureTask<Object> {
        private TaskHandle handle;
        private EvaluationEnvironment environment;
        private long startTime;
        private long doneTime;

        private EvaluationTask(EvaluationEnvironment evaluationEnvironment, TaskHandle taskHandle, Callable<Object> callable) {
            super(callable);
            this.environment = evaluationEnvironment;
            this.handle = taskHandle;
        }

        @Override
        public void run() {
            logger.finer("Run " + this + " " + this.handle);
            this.startTime = System.nanoTime();
            super.run();
        }

        long getEvaluationTime() {
            if (!this.isDone()) {
                throw new IllegalStateException("EvaluationTask is not yet done.");
            }
            return this.doneTime - this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            this.doneTime = System.nanoTime();
            super.done();
            logger.fine("Done " + this.handle + " (" + this.getEvaluationTime() + " ns)");
            if (this.environment.executor != null) {
                try {
                    this.get();
                    ParallelGreqlEvaluator.this.scheduleNext(this.environment, this.handle);
                }
                catch (InterruptedException interruptedException) {
                    this.environment.executor.shutdownNow();
                }
                catch (ExecutionException executionException) {
                    EvaluationEnvironment evaluationEnvironment = this.environment;
                    synchronized (evaluationEnvironment) {
                        if (this.environment.exception == null) {
                            this.environment.exception = executionException;
                        }
                    }
                    this.environment.executor.shutdownNow();
                }
            }
        }
    }
}

