/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.schema;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pcollections.PMap;

public class SourcePosition
implements Record {
    private static List<String> componentNames = new ArrayList<String>(2);
    private final int _length;
    private final int _offset;

    @Override
    public List<String> getComponentNames() {
        return componentNames;
    }

    @Override
    public boolean hasComponent(String string) {
        return componentNames.contains(string);
    }

    @Override
    public int size() {
        return 2;
    }

    public SourcePosition(int n, int n2) {
        this._length = n;
        this._offset = n2;
    }

    public SourcePosition(Map<String, Object> map) {
        assert (map.size() == 2);
        assert (map.containsKey("length"));
        this._length = (Integer)map.get("length");
        assert (map.containsKey("offset"));
        this._offset = (Integer)map.get("offset");
    }

    public SourcePosition(GraphIO graphIO) throws GraphIOException {
        graphIO.match("(");
        this._length = graphIO.matchInteger();
        this._offset = graphIO.matchInteger();
        graphIO.match(")");
    }

    public int get_length() {
        return this._length;
    }

    public int get_offset() {
        return this._offset;
    }

    @Override
    public Object getComponent(String string) {
        if (string.equals("length")) {
            return this._length;
        }
        if (string.equals("offset")) {
            return this._offset;
        }
        throw new NoSuchAttributeException("SourcePosition doesn't contain an attribute " + string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = String.valueOf(this._length);
        stringBuilder.append("[").append("length").append("=").append(string);
        String string2 = String.valueOf(this._offset);
        stringBuilder.append(", ").append("offset").append("=").append(string2);
        return stringBuilder.append("]").toString();
    }

    @Override
    public void writeComponentValues(GraphIO graphIO) throws IOException, GraphIOException {
        graphIO.writeSpace();
        graphIO.write("(");
        graphIO.noSpace();
        graphIO.writeInteger(this._length);
        graphIO.writeInteger(this._offset);
        graphIO.write(")");
    }

    @Override
    public PMap<String, Object> toPMap() {
        PMap<Object, Object> pMap = JGraLab.map();
        pMap = pMap.plus("length", this._length);
        pMap = pMap.plus("offset", this._offset);
        return pMap;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof SourcePosition) {
            SourcePosition sourcePosition = (SourcePosition)object;
            if (this._length != sourcePosition._length) {
                return false;
            }
            return this._offset == sourcePosition._offset;
        }
        if (object instanceof Record) {
            Record record = (Record)object;
            if (record.size() != 2) {
                return false;
            }
            try {
                if (!record.getComponent("length").equals(this._length)) {
                    return false;
                }
                return record.getComponent("offset").equals(this._offset);
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        n += Integer.valueOf(this._length).hashCode();
        return n += Integer.valueOf(this._offset).hashCode();
    }

    static {
        componentNames.add("length");
        componentNames.add("offset");
        componentNames = Collections.unmodifiableList(componentNames);
    }
}

