/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.ist.utilities.xml.IndentingXMLStreamWriter;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.serialising.DefaultWriter;
import de.uni_koblenz.jgralab.greql.serialising.XMLConstants;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class XMLOutputWriter
extends DefaultWriter
implements XMLConstants {
    private IndentingXMLStreamWriter writer = null;

    public XMLOutputWriter() {
        this(null);
    }

    public XMLOutputWriter(Graph graph) {
        super(graph);
    }

    public void writeValue(Object object, File file) throws XMLStreamException {
        try {
            this.writer = new IndentingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"), "\t");
            this.writeValue(object);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw factoryConfigurationError;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XMLStreamException(fileNotFoundException);
        }
        catch (SerialisingException serialisingException) {
            throw serialisingException;
        }
        catch (Exception exception) {
            throw new SerialisingException("Unhandled Exception", this.rootValue, exception);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new RuntimeException("An exception occured while closing the stream", xMLStreamException);
            }
        }
    }

    @Override
    protected void write(Object object) throws XMLStreamException {
        try {
            super.write(object);
        }
        catch (XMLStreamException xMLStreamException) {
            throw xMLStreamException;
        }
        catch (SerialisingException serialisingException) {
            throw serialisingException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected Exception", exception);
        }
    }

    @Override
    protected void head() throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("object");
        if (this.getGraph() != null) {
            this.writer.writeAttribute("graphId", this.getGraph().getId());
        }
    }

    @Override
    protected void foot() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.writeCharacters("\n");
        this.writer.flush();
    }

    @Override
    protected void writeAttributedElementClass(AttributedElementClass<?, ?> attributedElementClass) throws XMLStreamException {
        this.writer.writeEmptyElement("attributedElementClass");
        this.writer.writeAttribute("name", attributedElementClass.getQualifiedName());
        this.writer.writeAttribute("schema", attributedElementClass.getSchema().getQualifiedName());
    }

    @Override
    protected void writeBoolean(Boolean bl) throws XMLStreamException {
        this.writer.writeEmptyElement("boolean");
        this.writer.writeAttribute("value", bl.toString());
    }

    @Override
    protected void writeDouble(Double d) throws XMLStreamException {
        this.writer.writeEmptyElement("double");
        this.writer.writeAttribute("value", d.toString());
    }

    @Override
    protected void writeEdge(Edge edge) throws XMLStreamException {
        this.writer.writeEmptyElement("edge");
        this.writer.writeAttribute("id", Integer.toString(edge.getId()));
        if (edge.getGraph() != this.getGraph()) {
            this.writer.writeAttribute("graphId", String.valueOf(edge.getGraph().getId()));
        }
    }

    @Override
    protected void writeEnum(Enum<?> enum_) throws XMLStreamException {
        this.writer.writeEmptyElement("enum");
        this.writer.writeAttribute("value", enum_.name());
        this.writer.writeAttribute("type", enum_.getDeclaringClass().getCanonicalName());
    }

    @Override
    protected void writeGraph(Graph graph) throws XMLStreamException {
        this.writer.writeEmptyElement("graph");
        this.writer.writeAttribute("graphId", graph.getId());
    }

    @Override
    protected void writeInteger(Integer n) throws XMLStreamException {
        this.writer.writeEmptyElement("integer");
        this.writer.writeAttribute("value", n.toString());
    }

    @Override
    protected void writePVector(PVector<?> pVector) throws XMLStreamException {
        this.writer.writeStartElement("list");
        for (Object e : pVector) {
            this.write(e);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeLong(Long l) throws XMLStreamException {
        this.writer.writeEmptyElement("long");
        this.writer.writeAttribute("value", l.toString());
    }

    @Override
    protected void writePMap(PMap<?, ?> pMap) throws XMLStreamException {
        this.writer.writeStartElement("map");
        for (Map.Entry entry : pMap.entrySet()) {
            this.writer.writeStartElement("entry");
            this.write(entry.getKey());
            this.write(entry.getValue());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeRecord(Record record) throws XMLStreamException {
        this.writer.writeStartElement("record");
        for (String string : record.getComponentNames()) {
            this.writer.writeStartElement("comp");
            this.writer.writeAttribute("name", string);
            this.write(record.getComponent(string));
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writePSet(PSet<?> pSet) throws XMLStreamException {
        this.writer.writeStartElement("set");
        try {
            super.writePSet(pSet);
        }
        catch (XMLStreamException xMLStreamException) {
            throw xMLStreamException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected Exception", exception);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeString(String string) throws XMLStreamException {
        this.writer.writeEmptyElement("string");
        this.writer.writeAttribute("value", string.toString());
    }

    @Override
    protected void writeTuple(Tuple tuple) throws XMLStreamException {
        this.writer.writeStartElement("tup");
        try {
            super.writeTuple(tuple);
        }
        catch (XMLStreamException xMLStreamException) {
            throw xMLStreamException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected Exception", exception);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeVertex(Vertex vertex) throws XMLStreamException {
        this.writer.writeEmptyElement("vertex");
        this.writer.writeAttribute("id", String.valueOf(vertex.getId()));
        if (vertex.getGraph() != this.getGraph()) {
            this.writer.writeAttribute("graphId", String.valueOf(vertex.getGraph().getId()));
        }
    }

    @Override
    protected void writeTable(Table<?> table) throws XMLStreamException {
        this.writer.writeStartElement("table");
        try {
            super.writeTable(table);
        }
        catch (XMLStreamException xMLStreamException) {
            throw xMLStreamException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected Exception", exception);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writePath(Path path) throws XMLStreamException {
        this.writer.writeStartElement("path");
        this.write(path.getVertexTrace());
        this.write(path.getEdgeTrace());
        this.writer.writeEndElement();
    }

    @Override
    protected void writePathSystem(PathSystem pathSystem) throws XMLStreamException {
        this.writer.writeStartElement("pathSystem");
        this.writeNode(pathSystem, pathSystem.getRoot());
        this.writer.writeEndElement();
    }

    private void writeNode(PathSystem pathSystem, PathSystem.PathSystemNode pathSystemNode) throws XMLStreamException {
        this.writer.writeStartElement("node");
        this.writer.writeAttribute("state", new Integer(pathSystemNode.state).toString());
        this.writer.writeAttribute("isLeaf", new Boolean(pathSystem.isLeaf(pathSystemNode)).toString());
        this.writeVertex(pathSystemNode.currentVertex);
        if (pathSystemNode.edge2parent != null) {
            this.writeEdge(pathSystemNode.edge2parent);
        }
        for (PathSystem.PathSystemNode pathSystemNode2 : pathSystem.getChildren(pathSystemNode)) {
            this.writeNode(pathSystem, pathSystemNode2);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void writeUndefined() throws Exception {
        this.writer.writeEmptyElement("undefined");
    }
}

