/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.BitSet;
import org.pcollections.PSet;

public final class TypeCollection {
    private final PSet<TypeEntry> typeEntries;
    private PSet<TypeEntry> boundTypeEntries;
    private BitSet typeIdSet;
    private Schema schema;
    private int schemaVersion;
    private TcType tcType;
    private static TypeCollection empty = new TypeCollection(JGraLab.set());

    public static TypeCollection empty() {
        return empty;
    }

    public boolean isEmpty() {
        return this.typeEntries.isEmpty();
    }

    public TypeCollection with(String string, boolean bl, boolean bl2) {
        TypeEntry typeEntry = new TypeEntry(string, bl, bl2);
        if (this.typeEntries.contains(typeEntry)) {
            return this;
        }
        return new TypeCollection(this.typeEntries.plus(typeEntry));
    }

    public TypeCollection combine(TypeCollection typeCollection) {
        if (typeCollection.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return typeCollection;
        }
        return new TypeCollection(this.typeEntries.plusAll(typeCollection.typeEntries));
    }

    private TypeCollection(PSet<TypeEntry> pSet) {
        this.typeEntries = pSet;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        TypeCollection typeCollection = (TypeCollection)object;
        return this.typeEntries.equals(typeCollection.typeEntries);
    }

    public int hashCode() {
        return this.typeEntries.hashCode();
    }

    public boolean acceptsType(GraphElementClass<?, ?> graphElementClass) {
        assert (this.isBound());
        return this.isEmpty() || this.typeIdSet.get(graphElementClass.getGraphElementClassIdInSchema());
    }

    public boolean isBound() {
        return this.isEmpty() || this.schema != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "{";
        for (TypeEntry typeEntry : this.typeEntries) {
            stringBuilder.append(string).append(typeEntry.toString());
            string = ", ";
        }
        return stringBuilder.append("}").toString();
    }

    public double getFrequency(OptimizerInfo optimizerInfo) {
        if (this.isEmpty()) {
            return 1.0;
        }
        if (this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        for (TypeEntry typeEntry : this.boundTypeEntries) {
            if (typeEntry.forbidden) {
                d += typeEntry.exactType ? optimizerInfo.getFrequencyOfGraphElementClassWithoutSubclasses(typeEntry.gec) : optimizerInfo.getFrequencyOfGraphElementClass(typeEntry.gec);
                continue;
            }
            d2 += typeEntry.exactType ? optimizerInfo.getFrequencyOfGraphElementClassWithoutSubclasses(typeEntry.gec) : optimizerInfo.getFrequencyOfGraphElementClass(typeEntry.gec);
            bl = true;
        }
        d = Math.min(1.0, d);
        if (bl) {
            d2 = Math.min(1.0, d2);
            return Math.max(d2 - d, 0.0);
        }
        return 1.0 - d;
    }

    public long getEstimatedGraphElementCount(OptimizerInfo optimizerInfo) {
        if (!this.isEmpty() && this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        switch (this.tcType) {
            case VERTEX: {
                return (long)(this.getFrequency(optimizerInfo) * (double)optimizerInfo.getAverageVertexCount());
            }
            case EDGE: {
                return (long)(this.getFrequency(optimizerInfo) * (double)optimizerInfo.getAverageEdgeCount());
            }
        }
        return (long)(this.getFrequency(optimizerInfo) * (double)(optimizerInfo.getAverageVertexCount() + optimizerInfo.getAverageEdgeCount()));
    }

    public TypeCollection bindToSchema(InternalGreqlEvaluator internalGreqlEvaluator) {
        Schema schema = internalGreqlEvaluator.getSchema();
        if (schema == null) {
            throw new IllegalArgumentException("Evaluator doesn't contain a Schema");
        }
        if (!schema.isFinished()) {
            throw new IllegalStateException("Schema is not finished");
        }
        if (this.schema == null && schema != null) {
            return new TypeCollection(this.typeEntries, internalGreqlEvaluator, internalGreqlEvaluator.getSchema());
        }
        if (this.isEmpty()) {
            return this;
        }
        if (schema == this.schema && schema.getVersion() == this.schemaVersion) {
            return this;
        }
        return new TypeCollection(this.typeEntries, internalGreqlEvaluator, internalGreqlEvaluator.getSchema());
    }

    public TypeCollection bindToSchema(Schema schema) {
        if (!schema.isFinished()) {
            throw new IllegalStateException("Schema is not finished");
        }
        if (this.schema == null && schema != null) {
            return new TypeCollection(this.typeEntries, null, schema);
        }
        if (this.isEmpty()) {
            return this;
        }
        if (schema == this.schema && schema.getVersion() == this.schemaVersion) {
            return this;
        }
        return new TypeCollection(this.typeEntries, null, schema);
    }

    private TypeCollection(PSet<TypeEntry> pSet, InternalGreqlEvaluator internalGreqlEvaluator, Schema schema) {
        this(pSet);
        Object object;
        Object object2;
        this.schema = schema;
        this.schemaVersion = schema.getVersion();
        this.boundTypeEntries = JGraLab.set();
        for (TypeEntry object32 : this.typeEntries) {
            TypeEntry bl = new TypeEntry(object32.typeName, object32.exactType, object32.forbidden);
            if (internalGreqlEvaluator != null) {
                bl.gec = internalGreqlEvaluator.getGraphElementClass(bl.typeName);
            } else {
                bl.gec = (GraphElementClass)this.schema.getAttributedElementClass(bl.typeName);
                if (bl.gec == null) {
                    throw new UnknownTypeException(bl.typeName);
                }
            }
            if (this.boundTypeEntries.isEmpty()) {
                this.boundTypeEntries = this.boundTypeEntries.plus(bl);
                continue;
            }
            PSet pSet2 = this.boundTypeEntries;
            boolean bl2 = false;
            object2 = this.boundTypeEntries.iterator();
            while (object2.hasNext()) {
                object = (TypeEntry)object2.next();
                if (((TypeEntry)object).subsumes(bl)) {
                    bl2 = true;
                    continue;
                }
                if (!bl.subsumes((TypeEntry)object)) continue;
                pSet2 = pSet2.minus(object);
            }
            if (!bl2) {
                pSet2 = pSet2.plus((TypeEntry)bl);
            }
            this.boundTypeEntries = pSet2;
        }
        BitSet bitSet = new BitSet(schema.getGraphElementClassCount());
        BitSet bitSet2 = new BitSet(schema.getGraphElementClassCount());
        boolean bl = false;
        for (TypeEntry edgeClass : this.boundTypeEntries) {
            if (!edgeClass.forbidden) {
                bl = true;
            }
            Object object3 = object2 = edgeClass.gec instanceof VertexClass ? TcType.VERTEX : TcType.EDGE;
            this.tcType = this.tcType == null ? object2 : (object2 == this.tcType ? object2 : TcType.UNKNOWN);
            object = edgeClass.forbidden ? bitSet2 : bitSet;
            ((BitSet)object).set(edgeClass.gec.getGraphElementClassIdInSchema());
            if (edgeClass.exactType) continue;
            for (GraphElementClass graphElementClass : edgeClass.gec.getAllSubClasses()) {
                ((BitSet)object).set(graphElementClass.getGraphElementClassIdInSchema());
            }
        }
        if (!bl) {
            this.typeIdSet = bitSet2;
            this.typeIdSet.flip(0, this.schema.getGraphElementClassCount());
        } else {
            this.typeIdSet = bitSet;
            this.typeIdSet.andNot(bitSet2);
        }
        if (this.tcType == TcType.VERTEX) {
            for (EdgeClass vertexClass : this.schema.getGraphClass().getEdgeClasses()) {
                this.typeIdSet.clear(vertexClass.getGraphElementClassIdInSchema());
            }
        } else if (this.tcType == TcType.EDGE) {
            for (VertexClass vertexClass : this.schema.getGraphClass().getVertexClasses()) {
                this.typeIdSet.clear(vertexClass.getGraphElementClassIdInSchema());
            }
        }
        if (this.tcType == null) {
            this.tcType = TcType.UNKNOWN;
        }
    }

    public TcType getTcType() {
        if (this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        return this.tcType;
    }

    public BitSet getTypeIdSet() {
        if (this.schema == null) {
            throw new IllegalStateException("TypeCollection isn't bound to a Schema");
        }
        return this.typeIdSet;
    }

    static {
        TypeCollection.empty.tcType = TcType.UNKNOWN;
    }

    private static final class TypeEntry {
        String typeName;
        boolean exactType;
        boolean forbidden;
        GraphElementClass<?, ?> gec;

        public TypeEntry(String string, boolean bl, boolean bl2) {
            this.typeName = string;
            this.exactType = bl;
            this.forbidden = bl2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            TypeEntry typeEntry = (TypeEntry)object;
            return this.exactType == typeEntry.exactType && this.forbidden == typeEntry.forbidden && this.typeName.equals(typeEntry.typeName);
        }

        public int hashCode() {
            return this.typeName.hashCode();
        }

        public String toString() {
            return (this.forbidden ? "^" : "") + this.typeName + (this.exactType ? "!" : "");
        }

        private boolean subsumes(TypeEntry typeEntry) {
            assert (this.gec != null) : "TypeEntry is not bound to a schema";
            if (this.equals(typeEntry)) {
                return true;
            }
            if (this.exactType) {
                return false;
            }
            if (this.forbidden) {
                return this.gec.getAllSubClasses().contains(typeEntry.gec);
            }
            if (this.forbidden != typeEntry.forbidden) {
                return false;
            }
            return this.gec.getAllSubClasses().contains(typeEntry.gec);
        }
    }

    private static enum TcType {
        VERTEX,
        EDGE,
        UNKNOWN;

    }
}

