/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CopyDomain;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.CreateVertexClass;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class CopyVertexClass
extends Transformation<VertexClass> {
    private VertexClass sourceVC;
    private String alias;

    public CopyVertexClass(Context context, VertexClass vertexClass, String string) {
        super(context);
        this.sourceVC = vertexClass;
        this.alias = string;
    }

    public static CopyVertexClass parseAndCreate(ExecuteTransformation executeTransformation) {
        String string = "default";
        if (executeTransformation.tryMatchGraphAlias()) {
            string = executeTransformation.matchGraphAlias();
        }
        String string2 = executeTransformation.matchQualifiedName();
        if (executeTransformation.context.getSourceGraph(string) == null) {
            throw new GReTLException(executeTransformation.context, "There's no source graph with alias '" + string + "'.");
        }
        VertexClass vertexClass = executeTransformation.context.getSourceGraph(string).getSchema().getGraphClass().getVertexClass(string2);
        if (vertexClass == null) {
            throw new GReTLException(executeTransformation.context, "There's no VertexClass '" + string2 + "' in schema of graph with alias '" + string + "'.");
        }
        return new CopyVertexClass(executeTransformation.context, vertexClass, string);
    }

    @Override
    protected VertexClass transform() {
        String string = this.sourceVC.getQualifiedName();
        VertexClass vertexClass = (VertexClass)new CreateVertexClass(this.context, string, "#" + this.alias + "# V{" + string + "!}").execute();
        for (Attribute attribute : this.sourceVC.getOwnAttributeList()) {
            Domain domain = (Domain)new CopyDomain(this.context, attribute.getDomain()).execute();
            new CreateAttribute(this.context, new CreateAttribute.AttributeSpec(vertexClass, attribute.getName(), domain), "from v: keySet(img_" + string + ") reportMap v -> v." + attribute.getName() + " end").execute();
        }
        return vertexClass;
    }
}

