/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.SetAttributes;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import org.pcollections.PMap;

public class CreateAttribute
extends Transformation<Attribute> {
    private AttributeSpec attrSpec;
    private String semanticExpression;
    private PMap<? extends Object, ? extends Object> archetypes2values;

    protected CreateAttribute(Context context, AttributeSpec attributeSpec) {
        super(context);
        this.attrSpec = attributeSpec;
    }

    public CreateAttribute(Context context, AttributeSpec attributeSpec, PMap<? extends Object, ? extends Object> pMap) {
        this(context, attributeSpec);
        this.archetypes2values = pMap;
    }

    public CreateAttribute(Context context, AttributeSpec attributeSpec, String string) {
        this(context, attributeSpec);
        this.semanticExpression = string;
    }

    public static CreateAttribute parseAndCreate(ExecuteTransformation executeTransformation) {
        AttributeSpec attributeSpec = executeTransformation.matchAttributeSpec();
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new CreateAttribute(executeTransformation.context, attributeSpec, string);
    }

    @Override
    protected Attribute transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                this.attrSpec.aec.createAttribute(this.attrSpec.name, this.attrSpec.domain, this.attrSpec.defaultValue);
                Attribute attribute = this.attrSpec.aec.getAttribute(this.attrSpec.name);
                return attribute;
            }
            case GRAPH: {
                Attribute attribute = this.attrSpec.aec.getAttribute(this.attrSpec.name);
                if (this.archetypes2values != null) {
                    new SetAttributes(this.context, attribute, this.archetypes2values).execute();
                } else {
                    new SetAttributes(this.context, attribute, this.semanticExpression).execute();
                }
                return attribute;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }

    public static final class AttributeSpec {
        protected String name;
        protected AttributedElementClass<?, ?> aec;
        protected Domain domain;
        protected String defaultValue;

        public AttributeSpec(AttributedElementClass<?, ?> attributedElementClass, String string, Domain domain, String string2) {
            this.name = string;
            this.aec = attributedElementClass;
            this.domain = domain;
            this.defaultValue = string2;
        }

        public AttributeSpec(AttributedElementClass<?, ?> attributedElementClass, String string, Domain domain) {
            this(attributedElementClass, string, domain, null);
        }
    }
}

